/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.codemodel;

import java.net.URI;
import java.util.Objects;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public abstract class ClassFileObject
extends SimpleJavaFileObject {
    public ClassFileObject(String scheme, String name) {
        super(URI.create(Objects.requireNonNull(scheme) + ":///" + ClassFileObject.toClassFileName(Objects.requireNonNull(name))), JavaFileObject.Kind.CLASS);
    }

    public String getSimpleName() {
        String name = this.getName();
        int slash = name.lastIndexOf(47);
        String simpleName = slash > -1 ? name.substring(slash + 1) : name;
        if (!simpleName.endsWith(".class")) {
            throw new IllegalStateException(name);
        }
        simpleName = simpleName.substring(0, simpleName.length() - ".class".length());
        return simpleName;
    }

    public String getPackageName() {
        String packageName;
        String name = this.getName();
        int slash = name.lastIndexOf(47);
        if (slash > -1) {
            packageName = name.substring(0, slash);
            if (packageName.startsWith("/")) {
                packageName = packageName.substring("/".length());
            }
        } else {
            packageName = "";
        }
        return packageName.replace('/', '.');
    }

    private static String toClassFileName(String name) {
        return name.replace('.', '/') + ".class";
    }
}

