/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

class ThreadQueue {
    private Object[] queue;
    private int maxSize;
    private int size;
    private int head;
    private int tail;
    private volatile boolean isDestory = false;

    public ThreadQueue(int cap) {
        this.maxSize = cap > 0 ? cap : 1;
        this.queue = new Object[this.maxSize];
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean isFull() {
        return this.size == this.maxSize;
    }

    public synchronized void add(Object obj) throws InterruptedException {
        this.waitWhileFull();
        this.queue[this.head] = obj;
        this.head = (this.head + 1) % this.maxSize;
        ++this.size;
        this.notifyAll();
    }

    public synchronized Object remove() throws InterruptedException {
        this.waitWhileEmpty();
        Object obj = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.maxSize;
        --this.size;
        this.notifyAll();
        return obj;
    }

    public synchronized Object[] removeAll() throws InterruptedException {
        Object[] list = new Object[this.size];
        int i = 0;
        while (i < list.length) {
            list[i] = this.remove();
            ++i;
        }
        return list;
    }

    public synchronized boolean waitUntilEmpty(long msTimeout) throws InterruptedException {
        if (msTimeout == 0L) {
            this.waitUntilEmpty();
            return true;
        }
        long endTime = System.currentTimeMillis() + msTimeout;
        long msRemaining = msTimeout;
        while (!this.isEmpty() && msRemaining > 0L) {
            this.wait(msRemaining);
            msRemaining = endTime - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (!this.isDestory && this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilFull() throws InterruptedException {
        while (!this.isFull()) {
            this.wait();
        }
    }

    public synchronized void waitWhileFull() throws InterruptedException {
        while (!this.isDestory && this.isFull()) {
            this.wait();
        }
    }

    public synchronized void destory() throws InterruptedException {
        this.isDestory = true;
        this.notify();
    }
}

