/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import routines.system.TalendThread;
import routines.system.TalendThreadResult;
import routines.system.ThreadPoolWorker;
import routines.system.ThreadQueue;

public class TalendThreadPool {
    private volatile boolean stopAllWorkers = false;
    private TalendThread errorThread = null;
    private TalendThreadResult threadResult = new TalendThreadResult();
    private ThreadQueue idleWorkers;
    private ThreadPoolWorker[] workerList;

    public TalendThreadPool(int numberOfThreads) {
        numberOfThreads = Math.max(1, numberOfThreads);
        this.idleWorkers = new ThreadQueue(numberOfThreads);
        this.workerList = new ThreadPoolWorker[numberOfThreads];
        int i = 0;
        while (i < this.workerList.length) {
            this.workerList[i] = new ThreadPoolWorker(this.idleWorkers);
            ++i;
        }
    }

    public void execute(TalendThread target) throws InterruptedException {
        if (!this.stopAllWorkers) {
            ThreadPoolWorker worker = (ThreadPoolWorker)this.idleWorkers.remove();
            target.talendThreadPool = this;
            if (worker != null) {
                worker.process(target);
            }
        }
    }

    public void waitForEndOfQueue() {
        try {
            while (!this.stopAllWorkers && this.idleWorkers.getSize() != this.workerList.length) {
                Thread.sleep(100L);
            }
            int i = 0;
            while (i < this.workerList.length) {
                this.workerList[i].stopRequest();
                while (this.workerList[i].isAlive()) {
                    Thread.sleep(100L);
                }
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopAllWorkers() {
        if (!this.stopAllWorkers) {
            try {
                this.stopAllWorkers = true;
                this.idleWorkers.destory();
                int i = 0;
                while (i < this.workerList.length) {
                    this.workerList[i].stopRequest();
                    while (this.workerList[i].isAlive()) {
                        Thread.sleep(100L);
                    }
                    ++i;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public TalendThread getErrorThread() {
        return this.errorThread;
    }

    public void setErrorThread(TalendThread errorThread) {
        if (this.errorThread == null) {
            this.errorThread = errorThread;
        }
    }

    public TalendThreadResult getTalendThreadResult() {
        return this.threadResult;
    }
}

