/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedDBConnectionLog4j {
    private static boolean DEBUG = false;
    private static Logger LOGGER = null;
    private static String cid = null;
    private static SharedDBConnectionLog4j instance = null;
    private Map<String, Connection> sharedConnections = new HashMap<String, Connection>();

    private SharedDBConnectionLog4j() {
    }

    private static synchronized SharedDBConnectionLog4j getInstance() {
        if (instance == null) {
            instance = new SharedDBConnectionLog4j();
        }
        return instance;
    }

    private synchronized void debugSharedConnections() {
        String keys = "";
        if (DEBUG || LOGGER != null) {
            Set<String> keySet = this.sharedConnections.keySet();
            for (String key : keySet) {
                keys = String.valueOf(keys) + " " + key;
            }
        }
        if (DEBUG) {
            System.out.println("SharedDBConnection, current shared connections list is:" + keys);
        }
        this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, current shared connections list is:" + keys);
    }

    private synchronized void logMessage(boolean debug, String logInfo) {
        if (LOGGER != null) {
            if (debug) {
                LOGGER.debug(logInfo);
            } else {
                LOGGER.info(logInfo);
            }
        }
    }

    private synchronized Connection getConnection(String dbDriver, String url, String userName, String password, String dbConnectionName) throws ClassNotFoundException, SQLException {
        this.debugSharedConnections();
        Connection connection = this.sharedConnections.get(dbConnectionName);
        if (connection == null) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, can't find the key:" + dbConnectionName + " " + "so create a new one and share it.");
            }
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, can't find the key:" + dbConnectionName + " " + "so create a new one and share it.");
            this.logMessage(true, String.valueOf(cid) + " - Driver ClassName: " + dbDriver + ".");
            Class.forName(dbDriver);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection attempt to '" + url + "' with the username '" + userName + "'.");
            connection = DriverManager.getConnection(url, userName, password);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection to '" + url + "' has succeeded.");
            this.sharedConnections.put(dbConnectionName, connection);
            this.logMessage(true, String.valueOf(cid) + " - Shared Connection with key '" + dbConnectionName + "'");
        } else if (connection.isClosed()) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "But it is closed. So create a new one and share it.");
            }
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, find the key: " + dbConnectionName + " " + "But it is closed. So create a new one and share it.");
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection attempt to '" + url + "' with the username '" + userName + "'.");
            connection = DriverManager.getConnection(url, userName, password);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection to '" + url + "' has succeeded.");
            this.sharedConnections.put(dbConnectionName, connection);
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, Shared Connection with key '" + dbConnectionName + "'");
        } else {
            if (DEBUG) {
                System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "it is OK.");
            }
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, find the key: " + dbConnectionName + " " + "it is OK.");
        }
        return connection;
    }

    private synchronized Connection getConnection(String dbDriver, String url, String dbConnectionName) throws ClassNotFoundException, SQLException {
        this.debugSharedConnections();
        Connection connection = this.sharedConnections.get(dbConnectionName);
        if (connection == null) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, can't find the key:" + dbConnectionName + " " + "so create a new one and share it.");
            }
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, can't find the key:" + dbConnectionName + " " + "so create a new one and share it.");
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, Driver ClassName: " + dbDriver + ".");
            Class.forName(dbDriver);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection attempt to '" + url + ".");
            connection = DriverManager.getConnection(url);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection to '" + url + "' has succeeded.");
            this.sharedConnections.put(dbConnectionName, connection);
            this.logMessage(true, String.valueOf(cid) + " - Shared Connection with key '" + dbConnectionName + "'");
        } else if (connection.isClosed()) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "But it is closed. So create a new one and share it.");
            }
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, find the key: " + dbConnectionName + " " + "But it is closed. So create a new one and share it.");
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection attempt to '" + url + ".");
            connection = DriverManager.getConnection(url);
            this.logMessage(false, String.valueOf(cid) + " - SharedDBConnection, Connection to '" + url + "' has succeeded.");
            this.sharedConnections.put(dbConnectionName, connection);
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, Shared Connection with key '" + dbConnectionName + "'");
        } else {
            if (DEBUG) {
                System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "it is OK.");
            }
            this.logMessage(true, String.valueOf(cid) + " - SharedDBConnection, find the key: " + dbConnectionName + " " + "it is OK.");
        }
        return connection;
    }

    public static Connection getDBConnection(String dbDriver, String url, String userName, String password, String dbConnectionName) throws ClassNotFoundException, SQLException {
        SharedDBConnectionLog4j instanceLocal = SharedDBConnectionLog4j.getInstance();
        Connection connection = instanceLocal.getConnection(dbDriver, url, userName, password, dbConnectionName);
        return connection;
    }

    public static Connection getDBConnection(String dbDriver, String url, String dbConnectionName) throws ClassNotFoundException, SQLException {
        SharedDBConnectionLog4j instanceLocal = SharedDBConnectionLog4j.getInstance();
        Connection connection = instanceLocal.getConnection(dbDriver, url, dbConnectionName);
        return connection;
    }

    public static void clear() {
        instance = null;
    }

    public static void setDebugMode(boolean debug) {
        DEBUG = debug;
    }

    public static void initLogger(String loggerName, String uniqueName) {
        if (LOGGER == null) {
            LOGGER = LoggerFactory.getLogger((String)loggerName);
        }
        cid = uniqueName;
    }
}

