/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.talend.daikon.crypto.CipherSources;
import org.talend.daikon.crypto.Encryption;
import org.talend.daikon.crypto.KeySource;

public class PasswordEncryptUtil {
    private static final String PREFIX_PASSWORD = "enc:";
    private static final String SEPARATOR_PASSWORD = ":";
    public static final String PASSWORD_FOR_LOGS_VALUE = "...";

    private PasswordEncryptUtil() {
    }

    public static String encryptPassword(String input) throws Exception {
        if (input == null) {
            return input;
        }
        String keyName = JobKeySourceProvider.getInstance().getLatestKeyName();
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX_PASSWORD).append(keyName).append(SEPARATOR_PASSWORD).append(PasswordEncryptUtil.getEncryption(keyName).encrypt(input));
        return sb.toString();
    }

    public static String decryptPassword(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (input.startsWith(PREFIX_PASSWORD)) {
            String[] splitData = input.split("\\:");
            try {
                return PasswordEncryptUtil.getEncryption(splitData[1]).decrypt(splitData[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return input;
    }

    private static Encryption getEncryption(String keyName) throws Exception {
        return new Encryption(JobKeySourceProvider.getInstance().getKeySource(keyName), CipherSources.getDefault());
    }

    private static class InputStreamKeySources {
        private static final String KEY_PREFIX = "routine.encryption.key";
        private Map<String, KeySource> keySourceMap = new HashMap<String, KeySource>();
        private InputStream input;

        public InputStreamKeySources(InputStream input) throws Exception {
            this.input = input;
            this.init();
        }

        private void init() throws Exception {
            if (this.input != null) {
                try {
                    Properties props = new Properties();
                    props.load(this.input);
                    Enumeration<?> en = props.propertyNames();
                    while (en.hasMoreElements()) {
                        String value;
                        String key = (String)en.nextElement();
                        if (!key.startsWith(KEY_PREFIX) || (value = props.getProperty(key)) == null) continue;
                        final byte[] keyValue = Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
                        this.keySourceMap.put(key, new KeySource(){

                            public byte[] getKey() throws Exception {
                                return keyValue;
                            }
                        });
                    }
                }
                finally {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
            }
        }

        Set<String> getAllKeyNames() {
            return this.keySourceMap.keySet();
        }

        KeySource getKeySource(String keyName) {
            return this.keySourceMap.get(keyName);
        }
    }

    private static class JobKeySourceProvider {
        private static final String ENCRYPTION_KEY_PATH_PROP = "encryption.keys.file";
        private static InputStreamKeySources defaultKeySources;
        private static InputStreamKeySources fileKeySources;

        private JobKeySourceProvider() {
            String keyFilePath = System.getProperty(ENCRYPTION_KEY_PATH_PROP);
            if (keyFilePath != null && keyFilePath.length() > 0 && new File(keyFilePath).exists()) {
                try {
                    fileKeySources = new InputStreamKeySources(new FileInputStream(new File(keyFilePath)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                defaultKeySources = new InputStreamKeySources(PasswordEncryptUtil.class.getResourceAsStream("keys.properties"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public static JobKeySourceProvider getInstance() {
            return JobKeySourceProviderHolder.instance;
        }

        public KeySource getKeySource(String keyName) {
            if (fileKeySources != null && fileKeySources.getAllKeyNames().contains(keyName)) {
                return fileKeySources.getKeySource(keyName);
            }
            return defaultKeySources.getKeySource(keyName);
        }

        public String getLatestKeyName() {
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.addAll(defaultKeySources.getAllKeyNames());
            if (fileKeySources != null) {
                keyList.addAll(fileKeySources.getAllKeyNames());
            }
            return keyList.stream().max(Comparator.comparing(e -> this.getVersion((String)e))).get();
        }

        private Integer getVersion(String version) {
            int num = 0;
            if (version != null) {
                num = Integer.parseInt(version.substring(version.toLowerCase().lastIndexOf("v") + 1));
            }
            return num;
        }

        private static class JobKeySourceProviderHolder {
            private static final JobKeySourceProvider instance = new JobKeySourceProvider();

            private JobKeySourceProviderHolder() {
            }
        }
    }
}

