/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import routines.TalendDate;

public class FormatterUtils {
    private static final DecimalFormat df = new DecimalFormat("#.####################################", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    static {
        df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public static String fm(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Long) {
            return obj.toString();
        }
        if (obj instanceof Date) {
            return TalendDate.formatDate(pattern == null ? "dd-MM-yyyy" : pattern, (Date)obj);
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toPlainString();
        }
        if (obj instanceof Double) {
            return obj.toString();
        }
        if (obj instanceof Float) {
            return obj.toString();
        }
        if (obj instanceof Character) {
            return obj.toString();
        }
        if (obj instanceof char[]) {
            return FormatterUtils.format((char[])obj, null);
        }
        if (obj instanceof byte[]) {
            return FormatterUtils.format((byte[])obj, null);
        }
        return obj.toString();
    }

    public static String format(Object obj, String pattern) {
        return obj == null ? null : obj.toString();
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            return TalendDate.formatDate(pattern == null ? "dd-MM-yyyy" : pattern, date);
        }
        return null;
    }

    public static String format(BigDecimal decimal, String pattern) {
        if (decimal == null) {
            return null;
        }
        return decimal.toPlainString();
    }

    public static String format_BigDecimal(BigDecimal decimal, Integer scale) {
        if (decimal == null) {
            return null;
        }
        if (scale == null) {
            return decimal.toPlainString();
        }
        return decimal.setScale((int)scale, RoundingMode.HALF_UP).toPlainString();
    }

    public static String format(byte[] data, String pattern) {
        return Charset.defaultCharset().decode(ByteBuffer.wrap(data)).toString();
    }

    public static String format(char[] data, String pattern) {
        return String.valueOf(data);
    }

    public static String format(boolean b, String pattern) {
        return String.valueOf(b);
    }

    public static String format(char c, String pattern) {
        return String.valueOf(c);
    }

    public static String format(int i, String pattern) {
        return String.valueOf(i);
    }

    public static String format(long l, String pattern) {
        return String.valueOf(l);
    }

    public static String format(float f, String pattern) {
        return String.valueOf(f);
    }

    public static String format(double d, String pattern) {
        return String.valueOf(d);
    }

    public static String format_Date(Date date, String pattern) {
        if (date != null) {
            return TalendDate.formatDate(pattern == null ? "dd-MM-yyyy" : pattern, date);
        }
        return null;
    }

    public static String format_DateInUTC(Date date, String pattern) {
        if (date != null) {
            return TalendDate.formatDateInUTC(pattern == null ? "dd-MM-yyyy" : pattern, date);
        }
        return null;
    }

    public static String format_Date_Locale(Date date, String pattern, String locale) {
        if (date != null) {
            return TalendDate.formatDateLocale(pattern == null ? "dd-MM-yyyy" : pattern, date, locale);
        }
        return null;
    }

    public static String format_Number(String s, String thousandsSeparator, String decimalSeparator) {
        Character thousandsSeparatorChar = null;
        if (thousandsSeparator != null && !thousandsSeparator.isEmpty()) {
            thousandsSeparatorChar = Character.valueOf(thousandsSeparator.charAt(0));
        }
        Character decimalSeparatorChar = null;
        if (decimalSeparator != null && !decimalSeparator.isEmpty()) {
            decimalSeparatorChar = Character.valueOf(decimalSeparator.charAt(0));
        }
        return FormatterUtils.format_Number(s, thousandsSeparatorChar, decimalSeparatorChar);
    }

    public static String format_Number(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        int decimalIndex = s.indexOf(".");
        if (decimalIndex == -1) {
            if (thousandsSeparator != null) {
                return FormatterUtils.formatNumber(result, thousandsSeparator.charValue());
            }
            return result;
        }
        result = thousandsSeparator != null ? FormatterUtils.formatNumber(s.substring(0, decimalIndex), thousandsSeparator.charValue()) : s.substring(0, decimalIndex);
        result = decimalSeparator != null ? String.valueOf(result) + s.substring(decimalIndex).replace('.', decimalSeparator.charValue()) : String.valueOf(result) + s.substring(decimalIndex);
        return result;
    }

    private static String formatNumber(String s, char thousandsSeparator) {
        StringBuilder sb = new StringBuilder(s);
        int index = sb.length();
        index -= 3;
        while (index > 0 && sb.charAt(index - 1) != '-') {
            sb.insert(index, thousandsSeparator);
            index -= 3;
        }
        return sb.toString();
    }

    public static String unformat_Number(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        int decimalIndex = s.indexOf(decimalSeparator.charValue());
        if (decimalIndex == -1) {
            if (thousandsSeparator != null) {
                return FormatterUtils.unformatNumber(result, thousandsSeparator);
            }
            return result;
        }
        result = thousandsSeparator != null ? FormatterUtils.unformatNumber(s.substring(0, decimalIndex), thousandsSeparator) : s.substring(0, decimalIndex);
        result = decimalSeparator != null ? ("\\.".equals(decimalSeparator) ? String.valueOf(result) + s.substring(decimalIndex).replace(thousandsSeparator.charValue(), decimalSeparator.charValue()) : String.valueOf(result) + s.substring(decimalIndex).replace(decimalSeparator.charValue(), '.')) : String.valueOf(result) + s.substring(decimalIndex);
        return result;
    }

    private static String unformatNumber(String str, Character thousandsSeparator) {
        String[] s;
        StringBuilder returnString = new StringBuilder();
        String separator = thousandsSeparator.toString();
        if (".".equals(separator)) {
            separator = "\\.";
        }
        String[] stringArray = s = str.split(separator);
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            returnString.append(part);
            ++n2;
        }
        return returnString.toString();
    }

    public static String formatNumber(Object number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return FormatterUtils.formatUnwithE(number);
        }
        return df.format(number);
    }

    public static String formatNumber(double number) {
        return df.format(number);
    }

    public static String formatNumber(float number) {
        return FormatterUtils.formatUnwithE(Float.valueOf(number));
    }

    public static String formatUnwithE(Object arg) {
        String doubleString = String.valueOf(arg);
        int index = doubleString.indexOf("E");
        if (index != -1) {
            return new BigDecimal(doubleString).toPlainString();
        }
        return doubleString;
    }
}

