/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import routines.TalendString;

public class DocumentHelper {
    private static final String NAMESPACE_ATTRIBUTE_PREFIX = "xmlns";

    public static String getPath(Element element, Map<String, String> defaultNamespaceUriTOPrefix) {
        Element parent = element.getParent();
        if (parent == null) {
            return "/" + DocumentHelper.getXPathNameStep(element, defaultNamespaceUriTOPrefix);
        }
        return String.valueOf(DocumentHelper.getPath(parent, defaultNamespaceUriTOPrefix)) + "/" + DocumentHelper.getXPathNameStep(element, defaultNamespaceUriTOPrefix);
    }

    private static String getXPathNameStep(Element element, Map<String, String> defaultNamespaceUriTOPrefix) {
        String uri = element.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return element.getName();
        }
        String prefix = element.getNamespacePrefix();
        if (prefix == null || prefix.length() == 0) {
            String defaultNamespacePrefix = defaultNamespaceUriTOPrefix.get(uri);
            return String.valueOf(defaultNamespacePrefix) + ":" + element.getName();
        }
        return element.getQName().getQualifiedName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compareNodes(String path, Element element, Map<String, String> defaultNamespaceUriTOPrefix, Map<String, String> declaredNamespacesMapping, boolean appendDoc) {
        boolean samePath = path.equals(DocumentHelper.getPath(element, defaultNamespaceUriTOPrefix));
        if (!samePath) {
            return false;
        }
        if (!appendDoc) return true;
        List declaredNamespaces = element.declaredNamespaces();
        int size = declaredNamespaces.size();
        if (size == 0) {
            return declaredNamespacesMapping == null || declaredNamespacesMapping.size() == 0;
        }
        if (size == 1) {
            if (declaredNamespacesMapping == null || declaredNamespacesMapping.size() != 1) return false;
            Namespace namespace = (Namespace)declaredNamespaces.get(0);
            Iterator<Map.Entry<String, String>> iterator = declaredNamespacesMapping.entrySet().iterator();
            if (!iterator.hasNext()) return true;
            Map.Entry<String, String> entry = iterator.next();
            return namespace.getPrefix().equals(entry.getKey()) && namespace.getURI().equals(entry.getValue());
        }
        if (declaredNamespacesMapping == null || declaredNamespacesMapping.size() != size) return false;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (Namespace namespace : declaredNamespaces) {
            namespaces.put(namespace.getPrefix(), namespace.getURI());
        }
        return namespaces.hashCode() == declaredNamespacesMapping.hashCode() && namespaces.equals(declaredNamespacesMapping);
    }

    public static boolean isMatchAtRoot(Element root, Map<String, String> prefixToUri) {
        if (root == null) {
            return false;
        }
        Namespace namespace = root.getNamespace();
        String uri = namespace.getURI();
        if ("".equals(namespace.getPrefix()) && !"".equals(uri)) {
            for (Map.Entry<String, String> entry : prefixToUri.entrySet()) {
                if (!uri.equals(entry.getValue()) || entry.getKey() == null || !entry.getKey().startsWith("TPrefix")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void applyNamespace1(Element currentElement, String prefix, String uri) {
        DocumentHelper.applyNamespace2(currentElement, currentElement.getName(), prefix, uri);
    }

    public static void applyNamespace2(Element currentElement, String localName, String prefix, String uri) {
        currentElement.setQName(org.dom4j.DocumentHelper.createQName((String)localName, (Namespace)org.dom4j.DocumentHelper.createNamespace((String)prefix, (String)TalendString.replaceSpecialCharForXML(uri))));
    }

    public static void applyNamespace2Attribute(Element currentElement, String prefix, String localname, String value) {
        if (value == null) {
            return;
        }
        if (prefix == null) {
            if (NAMESPACE_ATTRIBUTE_PREFIX.equals(localname)) {
                currentElement.addNamespace("", value);
            } else {
                currentElement.addAttribute(localname, value);
            }
            return;
        }
        if (NAMESPACE_ATTRIBUTE_PREFIX.equals(prefix)) {
            currentElement.addNamespace(localname, value);
            return;
        }
        Namespace namespace = currentElement.getNamespaceForPrefix(prefix);
        if (namespace == null) {
            currentElement.addAttribute(localname, value);
        }
        currentElement.addAttribute(org.dom4j.DocumentHelper.createQName((String)localname, (Namespace)namespace), value);
    }
}

