/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import routines.system.DocumentToFlat;
import routines.system.ParserUtils;

public class Document
implements Serializable {
    private org.dom4j.Document doc = null;

    public void setDocument(org.dom4j.Document doc) {
        this.doc = doc;
    }

    public org.dom4j.Document getDocument() {
        return this.doc;
    }

    public String toString() {
        if (this.doc == null) {
            return null;
        }
        return this.doc.asXML();
    }

    public String formatXMLString(OutputFormat format) {
        if (this.doc == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(this.doc);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Format the XML document error.");
            return this.doc.asXML();
        }
        return ((Object)outputStream).toString();
    }

    public List<Map<String, Object>> LookupDocument(String loopXPath, boolean isOptionalLoop, Map<String, Object> lookupInfo, Map<String, String> xpathOfResults, Map<String, String> nsMapping, Map<String, String> xpathToTypeMap, Map<String, String> xpathToPatternMap, String matchingMode) {
        if (this.doc == null || lookupInfo == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        org.dom4j.Document document = this.doc.getDocument();
        DocumentToFlat docToFlat = new DocumentToFlat(lookupInfo, xpathOfResults, xpathToTypeMap, xpathToPatternMap);
        docToFlat.setDoc(document);
        docToFlat.setOriginalLoop(loopXPath);
        docToFlat.setXmlNameSpaceMap(nsMapping);
        docToFlat.flatForLookup(isOptionalLoop);
        if (docToFlat.isLoopChanged()) {
            lookupInfo = docToFlat.getLookupInfo();
            xpathOfResults = docToFlat.getXpathOfResults();
            xpathToTypeMap = docToFlat.getXpathToTypeMap();
            xpathToPatternMap = docToFlat.getXpathToPatternMap();
        }
        List<Node> nodes = docToFlat.getNodes();
        for (Node node : nodes) {
            boolean reject = false;
            if (!"ALL_ROWS".equals(matchingMode)) {
                for (String xpath : lookupInfo.keySet()) {
                    Object lookupValue = lookupInfo.get(xpath);
                    XPath xpathObjectForLookup = node.createXPath(xpath);
                    xpathObjectForLookup.setNamespaceURIs(nsMapping);
                    Node nodeOfLookup = xpathObjectForLookup.selectSingleNode((Object)node);
                    String text = nodeOfLookup == null ? null : xpathObjectForLookup.valueOf((Object)node);
                    String pattern = xpathToPatternMap.get(xpath);
                    String javaType = xpathToTypeMap.get(xpath);
                    Object value = ParserUtils.parse(text, javaType, pattern);
                    if (lookupValue == null && value == null || value != null && value.equals(lookupValue)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            HashMap<String, String> row = new HashMap<String, String>();
            for (String key : xpathOfResults.keySet()) {
                String xpath = xpathOfResults.get(key);
                XPath xpathObjectForResult = node.createXPath(xpath);
                xpathObjectForResult.setNamespaceURIs(nsMapping);
                Node nodeOfResult = xpathObjectForResult.selectSingleNode((Object)node);
                row.put(key.toString(), nodeOfResult == null ? null : nodeOfResult.getText());
            }
            result.add(row);
        }
        int count = result.size();
        if (count > 0) {
            ArrayList<Map<String, Object>> singleResult;
            if ("UNIQUE_MATCH".equals(matchingMode)) {
                singleResult = new ArrayList<Map<String, Object>>();
                singleResult.add((Map)result.get(count - 1));
                return singleResult;
            }
            if ("FIRST_MATCH".equals(matchingMode)) {
                singleResult = new ArrayList();
                singleResult.add((Map)result.get(0));
                return singleResult;
            }
        }
        return result;
    }
}

