/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.transpiler;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dmg.pmml.PMML;
import org.jpmml.model.PMMLUtil;
import org.jpmml.transpiler.TranspilerUtil;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--input", "--pmml-input", "--xml-input"}, description="PMML XML input file", required=true)
    private File input = null;
    @Parameter(names={"--output", "--jar-output"}, description="PMML service provider JAR output file")
    private File output = null;
    @Parameter(names={"--class-name"}, description="The fully qualified name of the transpiled PMML class", required=false)
    private String className = null;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        JCodeModel codeModel;
        File input = this.getInput();
        File output = this.getOutput();
        if (output == null) {
            output = new File(input.getAbsolutePath() + ".jar");
        } else if (output.isDirectory()) {
            output = new File(output, input.getName() + ".jar");
        }
        String className = this.getClassName();
        try (FileInputStream is = new FileInputStream(input);){
            PMML pmml = PMMLUtil.unmarshal((InputStream)is);
            codeModel = TranspilerUtil.translate(pmml, className);
        }
        try {
            TranspilerUtil.compile(codeModel);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        var6_6 = null;
        try (FileOutputStream os = new FileOutputStream(output);){
            TranspilerUtil.archive(codeModel, os);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

