/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import java.util.Collection;
import org.dmg.pmml.tree.Node;
import org.jpmml.translator.ArrayManager;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.tree.Scorer;
import org.jpmml.translator.tree.ScorerUtil;

public class NodeScoreManager
extends ArrayManager<Number>
implements Scorer<Number> {
    public static final JExpression RESULT_MISSING = JExpr.lit((int)-1);

    public NodeScoreManager(JType componentType, String name) {
        super(componentType, name);
    }

    @Override
    public Number prepare(Node node) {
        Object score = node.getScore();
        return (Number)score;
    }

    @Override
    public void yield(Number score, TranslationContext context) {
        context._return(this.createIndexExpression(score));
    }

    @Override
    public void yieldIf(JExpression expression, Number score, TranslationContext context) {
        context._returnIf(expression, this.createIndexExpression(score));
    }

    @Override
    public JExpression createExpression(Number score) {
        return ScorerUtil.format(score);
    }

    public JExpression createIndexExpression(Number score) {
        if (score == null) {
            return RESULT_MISSING;
        }
        return JExpr.lit((int)this.getOrInsert(score));
    }

    public Number[] getValues() {
        Collection elements = this.getElements();
        Number[] result = (Number[])elements.stream().toArray(Number[]::new);
        return result;
    }
}

