/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.util.List;
import org.dmg.pmml.PMMLObject;

public class IdentifierUtil {
    private IdentifierUtil() {
    }

    public static String sanitize(String name) {
        StringBuilder sb = new StringBuilder();
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (sb.length() == 0) {
                if (!Character.isJavaIdentifierStart(c)) continue;
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String create(String prefix, String name) {
        name = name.intern();
        return prefix + "$" + System.identityHashCode(name);
    }

    public static String create(String prefix, PMMLObject object) {
        return prefix + "$" + System.identityHashCode(object);
    }

    public static String create(String prefix, PMMLObject object, String name) {
        return IdentifierUtil.create(IdentifierUtil.create(prefix, object), name);
    }

    public static String create(String prefix, List<?> objects) {
        return prefix + "$" + System.identityHashCode(objects);
    }
}

