/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto.digest;

import org.apache.commons.codec.digest.DigestUtils;
import org.talend.daikon.crypto.EncodingUtils;
import org.talend.daikon.crypto.KeySource;
import org.talend.daikon.crypto.KeySources;
import org.talend.daikon.crypto.digest.DigestSource;

public class DigestSources {
    public static DigestSource sha256() {
        return (data, salt) -> {
            byte[] dataDigest = DigestUtils.sha256((String)data);
            if (salt == null || salt.length == 0) {
                return EncodingUtils.BASE64_ENCODER.apply(dataDigest);
            }
            byte[] digestedSalt = DigestUtils.sha256((byte[])salt);
            byte[] result = new byte[digestedSalt.length + dataDigest.length];
            System.arraycopy(digestedSalt, 0, result, 0, digestedSalt.length);
            System.arraycopy(dataDigest, 0, result, digestedSalt.length, dataDigest.length);
            return EncodingUtils.BASE64_ENCODER.apply(result);
        };
    }

    public static DigestSource pbkDf2() {
        return (value, salt) -> {
            KeySource keySource = KeySources.pbkDf2(value, salt, 256);
            try {
                return EncodingUtils.BASE64_ENCODER.apply(keySource.getKey());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to digest value.", e);
            }
        };
    }
}

