/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.crypto.EncodingUtils;
import org.talend.daikon.crypto.KeySource;

public class KeySources {
    private KeySources() {
    }

    public static KeySource empty() {
        return () -> new byte[0];
    }

    public static KeySource random(final int length) {
        return new KeySource(){
            private byte[] key;

            @Override
            public synchronized byte[] getKey() {
                if (this.key == null) {
                    this.key = new byte[length];
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(this.key);
                }
                return this.key;
            }
        };
    }

    public static KeySource machineUID(int uidLength) {
        return () -> {
            byte[] key = new byte[uidLength];
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            int keyPos = 0;
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                for (byte b : mac) {
                    int n = keyPos++ % key.length;
                    key[n] = (byte)(key[n] + b);
                }
            }
            return key;
        };
    }

    public static KeySource fixedKey(String key) {
        return key::getBytes;
    }

    public static KeySource systemProperty(String systemProperty) {
        return () -> Optional.ofNullable(System.getProperty(systemProperty)).orElseThrow(() -> new IllegalArgumentException("System property '" + systemProperty + "' not found")).getBytes();
    }

    public static KeySource pbkDf2(String password, byte[] salt, int keyLength) {
        return () -> {
            if (salt == null || salt.length == 0) {
                throw new IllegalArgumentException("Cannot use pbkDf2 with empty or null salt.");
            }
            try {
                PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, keyLength);
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
                return factory.generateSecret(spec).getEncoded();
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Unable to generate key.", e);
            }
        };
    }

    public static KeySource file(String propertyName) {
        return new FileSource(propertyName);
    }

    private static class FileSource
    implements KeySource {
        private static final Logger LOGGER = Logger.getLogger(FileSource.class.getCanonicalName());
        private final Properties properties = new Properties();
        private final String propertyName;

        private FileSource(String propertyName) {
            this.init();
            this.propertyName = propertyName;
        }

        private void init() {
            block27: {
                try {
                    try (InputStream standardKeyFile = KeySources.class.getResourceAsStream("key.dat");){
                        this.properties.load(standardKeyFile);
                    }
                    String filePath = System.getProperty("encryption.keys.file");
                    if (!StringUtils.isNotEmpty((CharSequence)filePath) || !new File(filePath).exists()) break block27;
                    try (FileInputStream in = new FileInputStream(new File(filePath));){
                        this.properties.load(in);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Unable to load key file.", e);
                }
            }
        }

        @Override
        public byte[] getKey() throws Exception {
            Object propertyObject = this.properties.get(this.propertyName);
            if (propertyObject == null) {
                throw new IllegalArgumentException("Property '" + this.propertyName + "' does not exist.");
            }
            String o = String.valueOf(propertyObject);
            return EncodingUtils.BASE64_DECODER.apply(o.getBytes("UTF-8"));
        }
    }
}

