/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto;

import java.security.Key;
import java.security.Provider;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.talend.daikon.crypto.CipherSource;
import org.talend.daikon.crypto.EncodingUtils;
import org.talend.daikon.crypto.KeySource;
import org.talend.daikon.crypto.KeySources;

public class CipherSources {
    private static final String ENCODING = "UTF-8";

    private CipherSources() {
    }

    public static CipherSource getDefault() {
        return CipherSources.aesGcm(12, 16, null);
    }

    public static CipherSource aes() {
        return CipherSources.aes(null);
    }

    public static CipherSource aes(final Provider p) {
        return new CipherSource(){

            private Cipher get(KeySource source, int mode) throws Exception {
                Cipher c = p != null ? Cipher.getInstance("AES", p) : Cipher.getInstance("AES");
                SecretKeySpec keySpec = new SecretKeySpec(source.getKey(), "AES");
                c.init(mode, keySpec);
                return c;
            }

            @Override
            public String encrypt(KeySource source, String data) throws Exception {
                byte[] encryptedBytes = this.get(source, 1).doFinal(data.getBytes(CipherSources.ENCODING));
                return EncodingUtils.BASE64_ENCODER.apply(encryptedBytes);
            }

            @Override
            public String decrypt(KeySource source, String data) throws Exception {
                byte[] bytes = EncodingUtils.BASE64_DECODER.apply(data.getBytes());
                return new String(this.get(source, 2).doFinal(bytes), CipherSources.ENCODING);
            }
        };
    }

    public static CipherSource aesGcm(int ivLength) {
        return CipherSources.aesGcm(ivLength, 16, null);
    }

    public static CipherSource aesGcm(int ivLength, final int tagLength, final Provider p) {
        if (Stream.of(16, 15, 14, 13, 12).noneMatch(i -> i == tagLength)) {
            throw new IllegalArgumentException("Invalid authentication tag length");
        }
        return new SymmetricKeyCipherSource(ivLength){

            @Override
            protected Cipher get(KeySource source, int encryptMode, byte[] iv) throws Exception {
                Cipher c = p != null ? Cipher.getInstance("AES/GCM/NoPadding", p) : Cipher.getInstance("AES/GCM/NoPadding");
                byte[] sourceKey = source.getKey();
                SecretKeySpec key = new SecretKeySpec(sourceKey, "AES");
                GCMParameterSpec spec = new GCMParameterSpec(tagLength * 8, iv);
                c.init(encryptMode, (Key)key, spec);
                return c;
            }
        };
    }

    public static CipherSource blowfish() throws Exception {
        return CipherSources.blowfish(null);
    }

    public static CipherSource blowfish(final Provider p) throws Exception {
        int ivLength = 8;
        return new SymmetricKeyCipherSource(ivLength){

            @Override
            protected Cipher get(KeySource source, int encryptMode, byte[] iv) throws Exception {
                Cipher c = p != null ? Cipher.getInstance("Blowfish/CBC/PKCS5Padding", p) : Cipher.getInstance("Blowfish/CBC/PKCS5Padding");
                byte[] sourceKey = source.getKey();
                SecretKeySpec key = new SecretKeySpec(sourceKey, "Blowfish");
                IvParameterSpec spec = new IvParameterSpec(iv);
                c.init(encryptMode, (Key)key, spec);
                return c;
            }
        };
    }

    private static abstract class SymmetricKeyCipherSource
    implements CipherSource {
        private int ivLength;

        SymmetricKeyCipherSource(int ivLength) {
            this.ivLength = ivLength;
        }

        @Override
        public String encrypt(KeySource source, String data) throws Exception {
            byte[] dataBytes = data.getBytes(CipherSources.ENCODING);
            byte[] iv = KeySources.random(this.ivLength).getKey();
            Cipher cipher = this.get(source, 1, iv);
            byte[] encryptedData = cipher.doFinal(dataBytes);
            byte[] encryptedBytes = new byte[encryptedData.length + this.ivLength];
            System.arraycopy(iv, 0, encryptedBytes, 0, this.ivLength);
            System.arraycopy(encryptedData, 0, encryptedBytes, this.ivLength, encryptedData.length);
            return EncodingUtils.BASE64_ENCODER.apply(encryptedBytes);
        }

        protected abstract Cipher get(KeySource var1, int var2, byte[] var3) throws Exception;

        @Override
        public String decrypt(KeySource source, String data) throws Exception {
            byte[] encryptedBytes = EncodingUtils.BASE64_DECODER.apply(data.getBytes(CipherSources.ENCODING));
            byte[] iv = new byte[this.ivLength];
            System.arraycopy(encryptedBytes, 0, iv, 0, this.ivLength);
            Cipher cipher = this.get(source, 2, iv);
            return new String(cipher.doFinal(encryptedBytes, this.ivLength, encryptedBytes.length - this.ivLength), CipherSources.ENCODING);
        }
    }
}

