/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.tjdbcsp;

import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.components.api.component.PropertyPathConnector;
import org.talend.components.api.properties.ComponentReferenceProperties;
import org.talend.components.common.FixedConnectorsComponentProperties;
import org.talend.components.common.SchemaProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.module.SPParameterTable;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.tjdbcconnection.TJDBCConnectionProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class TJDBCSPProperties
extends FixedConnectorsComponentProperties
implements RuntimeSettingProvider {
    public ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent = new ComponentReferenceProperties("referencedComponent", "tJDBCConnection");
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection");
    public transient PropertyPathConnector MAIN_CONNECTOR = new PropertyPathConnector("MAIN", "main");
    public transient PropertyPathConnector FLOW_CONNECTOR = new PropertyPathConnector("MAIN", "schemaFlow");
    public SchemaProperties main = new SchemaProperties("main"){

        public void afterSchema() {
            TJDBCSPProperties.this.updateOutputSchemas();
            TJDBCSPProperties.this.updateReturnResultIn();
            TJDBCSPProperties.this.updateSpParameterTable();
        }
    };
    public SchemaProperties schemaFlow = new SchemaProperties("schemaFlow");
    public Property<String> spName = PropertyFactory.newProperty((String)"spName").setRequired();
    public Property<Boolean> isFunction = PropertyFactory.newBoolean((String)"isFunction").setRequired();
    public Property<String> returnResultIn = PropertyFactory.newProperty((String)"returnResultIn").setRequired();
    public SPParameterTable spParameterTable = new SPParameterTable("spParameterTable");
    public Property<Boolean> useDataSource = PropertyFactory.newBoolean((String)"useDataSource").setRequired();
    public Property<String> dataSource = PropertyFactory.newProperty((String)"dataSource").setRequired();

    public TJDBCSPProperties(String name) {
        super(name);
    }

    public void updateOutputSchemas() {
        Schema inputSchema = (Schema)this.main.schema.getValue();
        this.schemaFlow.schema.setValue((Object)inputSchema);
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        Widget compListWidget = Widget.widget(this.referencedComponent).setWidgetType("widget.type.component.reference");
        mainForm.addRow(compListWidget);
        mainForm.addRow((NamedThing)this.connection.getForm("Main"));
        mainForm.addRow(this.spName);
        mainForm.addRow(this.isFunction);
        mainForm.addRow(Widget.widget(this.returnResultIn).setWidgetType("widget.type.enumeration"));
        mainForm.addRow(Widget.widget((NamedThing)this.spParameterTable).setWidgetType("widget.type.table"));
        mainForm.addRow((NamedThing)this.main.getForm("Reference"));
        mainForm.addRow(this.useDataSource);
        mainForm.addRow(this.dataSource);
    }

    public void setupProperties() {
        super.setupProperties();
        this.connection.setNotRequired();
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        boolean useOtherConnection = CommonUtils.useExistedConnection(this.referencedComponent);
        if (form.getName().equals("Main")) {
            form.getChildForm(this.connection.getName()).setHidden(useOtherConnection);
            if (useOtherConnection) {
                form.getWidget(this.useDataSource.getName()).setHidden(true);
                form.getWidget(this.dataSource.getName()).setHidden(true);
            } else {
                form.getWidget(this.useDataSource.getName()).setHidden(false);
                form.getWidget(this.dataSource.getName()).setHidden((Boolean)this.useDataSource.getValue() == false);
            }
            form.getWidget(this.returnResultIn.getName()).setVisible(((Boolean)this.isFunction.getValue()).booleanValue());
        }
    }

    public void afterReferencedComponent() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterUseDataSource() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterIsFunction() {
        this.refreshLayout(this.getForm("Main"));
    }

    private void updateReturnResultIn() {
        CommonUtils.updatePossibleValues(this.returnResultIn, CommonUtils.getAllSchemaFieldNames((Schema)this.main.schema.getValue()));
    }

    private void updateSpParameterTable() {
        this.spParameterTable.schemaColumns.setPossibleValues(CommonUtils.getAllSchemaFieldNames((Schema)this.main.schema.getValue()));
    }

    protected Set<PropertyPathConnector> getAllSchemaPropertiesConnectors(boolean isOutputConnection) {
        HashSet<PropertyPathConnector> connectors = new HashSet<PropertyPathConnector>();
        if (isOutputConnection) {
            connectors.add(this.FLOW_CONNECTOR);
        } else {
            connectors.add(this.MAIN_CONNECTOR);
        }
        return connectors;
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setReferenceInfo(setting, this.referencedComponent);
        CommonUtils.setCommonConnectionInfo(setting, this.connection);
        setting.setSpName((String)this.spName.getValue());
        setting.setIsFunction((Boolean)this.isFunction.getValue());
        setting.setReturnResultIn((String)this.returnResultIn.getValue());
        setting.setSchemaColumns4SPParameters(this.spParameterTable.schemaColumns.getValue());
        setting.setParameterTypes(this.spParameterTable.parameterTypes.getValue());
        setting.setUseDataSource((Boolean)this.useDataSource.getValue());
        setting.setDataSource((String)this.dataSource.getValue());
        return setting;
    }
}

