/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.tjdbcoutput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.components.api.component.PropertyPathConnector;
import org.talend.components.api.properties.ComponentReferenceProperties;
import org.talend.components.common.FixedConnectorsComponentProperties;
import org.talend.components.common.SchemaProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.JdbcRuntimeInfo;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.AdditionalColumnsTable;
import org.talend.components.jdbc.module.FieldOptionsTable;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.module.JDBCTableSelectionModule;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSink;
import org.talend.components.jdbc.tjdbcconnection.TJDBCConnectionProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;
import org.talend.daikon.properties.runtime.RuntimeContext;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.runtime.RuntimeUtil;
import org.talend.daikon.sandbox.SandboxedInstance;

public class TJDBCOutputProperties
extends FixedConnectorsComponentProperties
implements RuntimeSettingProvider {
    public ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent = new ComponentReferenceProperties("referencedComponent", "tJDBCConnection");
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection");
    public JDBCTableSelectionModule tableSelection = new JDBCTableSelectionModule("tableSelection");
    public Property<DataAction> dataAction = PropertyFactory.newEnum((String)"dataAction", DataAction.class).setRequired();
    public Property<Boolean> clearDataInTable = PropertyFactory.newBoolean((String)"clearDataInTable").setRequired();
    public transient PropertyPathConnector MAIN_CONNECTOR = new PropertyPathConnector("MAIN", "main");
    public transient PropertyPathConnector FLOW_CONNECTOR = new PropertyPathConnector("MAIN", "schemaFlow");
    public transient PropertyPathConnector REJECT_CONNECTOR = new PropertyPathConnector("REJECT", "schemaReject");
    public SchemaProperties main = new SchemaProperties("main"){

        public void afterSchema() {
            TJDBCOutputProperties.this.updateOutputSchemas();
        }
    };
    public SchemaProperties schemaFlow = new SchemaProperties("schemaFlow");
    public SchemaProperties schemaReject = new SchemaProperties("schemaReject");
    public final transient PresentationItem fetchSchemaFromTable = new PresentationItem("fetchSchemaFromTable", "Guess schema");
    public Property<Boolean> dieOnError = PropertyFactory.newBoolean((String)"dieOnError").setRequired();
    public Property<Boolean> useDataSource = PropertyFactory.newBoolean((String)"useDataSource").setRequired();
    public Property<String> dataSource = PropertyFactory.newProperty((String)"dataSource").setRequired();
    public Property<Integer> commitEvery = PropertyFactory.newInteger((String)"commitEvery").setRequired();
    public AdditionalColumnsTable additionalColumns = new AdditionalColumnsTable("additionalColumns");
    public Property<Boolean> enableFieldOptions = PropertyFactory.newBoolean((String)"enableFieldOptions").setRequired();
    public FieldOptionsTable fieldOptions = new FieldOptionsTable("fieldOptions");
    public Property<Boolean> debug = PropertyFactory.newBoolean((String)"debug").setRequired();
    public Property<Boolean> useBatch = PropertyFactory.newBoolean((String)"useBatch").setRequired();
    public Property<Integer> batchSize = PropertyFactory.newInteger((String)"batchSize").setRequired();

    public TJDBCOutputProperties(String name) {
        super(name);
    }

    public void updateOutputSchemas() {
        Schema inputSchema = (Schema)this.main.schema.getValue();
        this.schemaFlow.schema.setValue((Object)inputSchema);
        ArrayList<Schema.Field> additionalRejectFields = new ArrayList<Schema.Field>();
        Schema.Field field = new Schema.Field("errorCode", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        field.addProp("talend.isLocked", "false");
        field.addProp("talend.field.generated", "true");
        field.addProp("talend.field.length", "255");
        additionalRejectFields.add(field);
        field = new Schema.Field("errorMessage", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        field.addProp("talend.isLocked", "false");
        field.addProp("talend.field.generated", "true");
        field.addProp("talend.field.length", "255");
        additionalRejectFields.add(field);
        Schema rejectSchema = CommonUtils.newSchema(inputSchema, "rejectOutput", additionalRejectFields);
        this.schemaReject.schema.setValue((Object)rejectSchema);
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        Widget compListWidget = Widget.widget(this.referencedComponent).setWidgetType("widget.type.component.reference");
        mainForm.addRow(compListWidget);
        mainForm.addRow((NamedThing)this.connection.getForm("Main"));
        mainForm.addRow((NamedThing)this.tableSelection.getForm("Reference"));
        mainForm.addRow(this.dataAction);
        mainForm.addColumn(this.clearDataInTable);
        mainForm.addRow((NamedThing)this.main.getForm("Reference"));
        mainForm.addRow(Widget.widget((NamedThing)this.fetchSchemaFromTable).setWidgetType("widget.type.button"));
        mainForm.addRow(this.dieOnError);
        mainForm.addRow(this.useDataSource);
        mainForm.addRow(this.dataSource);
        Form advancedForm = CommonUtils.addForm((Properties)this, "Advanced");
        advancedForm.addRow(this.commitEvery);
        advancedForm.addRow(Widget.widget((NamedThing)this.additionalColumns).setWidgetType("widget.type.table"));
        advancedForm.addRow(this.enableFieldOptions);
        advancedForm.addRow(Widget.widget((NamedThing)this.fieldOptions).setWidgetType("widget.type.table"));
        advancedForm.addRow(this.debug);
        advancedForm.addRow(this.useBatch);
        advancedForm.addRow(this.batchSize);
    }

    public void setupProperties() {
        super.setupProperties();
        this.dataAction.setValue((Object)DataAction.INSERT);
        this.commitEvery.setValue((Object)10000);
        this.useBatch.setValue((Object)true);
        this.batchSize.setValue((Object)10000);
        this.tableSelection.setConnection(this);
        this.connection.setNotRequired();
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        boolean useOtherConnection = CommonUtils.useExistedConnection(this.referencedComponent);
        if (form.getName().equals("Main")) {
            form.getChildForm(this.connection.getName()).setHidden(useOtherConnection);
            if (useOtherConnection) {
                form.getWidget(this.useDataSource.getName()).setHidden(true);
                form.getWidget(this.dataSource.getName()).setHidden(true);
            } else {
                form.getWidget(this.useDataSource.getName()).setHidden(false);
                form.getWidget(this.dataSource.getName()).setHidden((Boolean)this.useDataSource.getValue() == false);
            }
        }
        if (form.getName().equals("Advanced")) {
            form.getWidget(this.commitEvery.getName()).setHidden(useOtherConnection);
            if (this.dataAction.getValue() == DataAction.INSERT || this.dataAction.getValue() == DataAction.UPDATE || this.dataAction.getValue() == DataAction.DELETE) {
                form.getWidget(this.useBatch.getName()).setHidden(false);
                form.getWidget(this.batchSize.getName()).setHidden((Boolean)this.useBatch.getValue() == false);
            } else {
                form.getWidget(this.useBatch.getName()).setHidden(true);
                form.getWidget(this.batchSize.getName()).setHidden(true);
            }
            form.getWidget(this.fieldOptions.getName()).setVisible(((Boolean)this.enableFieldOptions.getValue()).booleanValue());
            this.updateReferenceColumns();
            this.updateFieldOptions();
        }
    }

    private void updateReferenceColumns() {
        Schema schema = (Schema)this.main.schema.getValue();
        if (schema == null) {
            return;
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Schema.Field f : schema.getFields()) {
            fieldNames.add(f.name());
        }
        this.additionalColumns.referenceColumns.setPossibleValues(fieldNames);
    }

    public void afterReferencedComponent() {
        this.refreshLayout(this.getForm("Main"));
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterUseDataSource() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterDataAction() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterUseBatch() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterEnableFieldOptions() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    private void updateFieldOptions() {
        Schema schema = (Schema)this.main.schema.getValue();
        if (schema == null) {
            return;
        }
        Map<String, FieldOption> oldValues = this.getOldFieldOptions();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Boolean> insertable = new ArrayList<Boolean>();
        ArrayList<Boolean> updateable = new ArrayList<Boolean>();
        for (Schema.Field f : schema.getFields()) {
            fieldNames.add(f.name());
            FieldOption oldValue = null;
            if (oldValues != null && (oldValue = oldValues.get(f.name())) != null) {
                insertable.add(oldValue.insertable);
                updateable.add(oldValue.updatable);
                continue;
            }
            insertable.add(true);
            updateable.add(true);
        }
        this.fieldOptions.schemaColumns.setValue(fieldNames);
        this.fieldOptions.insertable.setValue(insertable);
        this.fieldOptions.updatable.setValue(updateable);
    }

    private Map<String, FieldOption> getOldFieldOptions() {
        HashMap<String, FieldOption> oldValueMap = null;
        Object fs = this.fieldOptions.schemaColumns.getValue();
        Object is = this.fieldOptions.insertable.getValue();
        Object us = this.fieldOptions.updatable.getValue();
        if (fs != null && is != null && us != null && fs instanceof List && is instanceof List && us instanceof List) {
            oldValueMap = new HashMap<String, FieldOption>();
            List names = (List)fs;
            List insertables = (List)is;
            List updatables = (List)us;
            for (int i = 0; i < names.size(); ++i) {
                FieldOption option = new FieldOption();
                option.fieldName = (String)names.get(i);
                Object its = insertables.get(i);
                Object uts = updatables.get(i);
                option.insertable = its instanceof Boolean ? ((Boolean)its).booleanValue() : Boolean.valueOf((String)its).booleanValue();
                option.updatable = its instanceof Boolean ? ((Boolean)uts).booleanValue() : Boolean.valueOf((String)uts).booleanValue();
                oldValueMap.put(option.fieldName, option);
            }
        }
        return oldValueMap;
    }

    protected Set<PropertyPathConnector> getAllSchemaPropertiesConnectors(boolean isOutputConnection) {
        HashSet<PropertyPathConnector> connectors = new HashSet<PropertyPathConnector>();
        if (isOutputConnection) {
            connectors.add(this.FLOW_CONNECTOR);
            connectors.add(this.REJECT_CONNECTOR);
        } else {
            connectors.add(this.MAIN_CONNECTOR);
        }
        return connectors;
    }

    public ValidationResult afterFetchSchemaFromTable(RuntimeContext runtimeContext) {
        Object mappingFileLocation = runtimeContext.getData("MAPPING_LOCATION");
        if (mappingFileLocation == null) {
            return new ValidationResult(ValidationResult.Result.ERROR, "can't find the mapping files directory");
        }
        JdbcRuntimeInfo jdbcRuntimeInfo = new JdbcRuntimeInfo(this, "org.talend.components.jdbc.runtime.JDBCSource");
        try (SandboxedInstance sandboxI = RuntimeUtil.createRuntimeClassWithCurrentJVMProperties((RuntimeInfo)jdbcRuntimeInfo, (ClassLoader)((Object)((Object)this.connection)).getClass().getClassLoader());){
            JdbcRuntimeSourceOrSink ss = (JdbcRuntimeSourceOrSink)sandboxI.getInstance();
            ss.initialize(null, (Properties)this);
            Schema schema = null;
            try {
                ss.setDBTypeMapping(CommonUtils.getMapping((String)mappingFileLocation, this.getRuntimeSetting(), null, null));
                schema = ss.getEndpointSchema(null, (String)this.tableSelection.tablename.getValue());
            }
            catch (Exception e) {
                ValidationResult validationResult = new ValidationResult(ValidationResult.Result.ERROR, CommonUtils.getClearExceptionInfo(e));
                if (sandboxI != null) {
                    if (var5_5 != null) {
                        try {
                            sandboxI.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        sandboxI.close();
                    }
                }
                return validationResult;
            }
            this.main.schema.setValue((Object)schema);
            this.updateOutputSchemas();
        }
        return ValidationResult.OK;
    }

    public ValidationResult afterFetchSchemaFromTable() {
        return ValidationResult.OK;
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setReferenceInfoAndConnectionInfo(setting, this.referencedComponent, this.connection);
        setting.setTablename((String)this.tableSelection.tablename.getValue());
        setting.setDataAction((DataAction)((Object)this.dataAction.getValue()));
        setting.setClearDataInTable((Boolean)this.clearDataInTable.getValue());
        setting.setDieOnError((Boolean)this.dieOnError.getValue());
        setting.setUseAutoCommit((Boolean)this.useDataSource.getValue());
        setting.setDataSource((String)this.dataSource.getValue());
        setting.setCommitEvery((Integer)this.commitEvery.getValue());
        setting.setDebug((Boolean)this.debug.getValue());
        setting.setUseBatch((Boolean)this.useBatch.getValue());
        setting.setBatchSize((Integer)this.batchSize.getValue());
        setting.setNewDBColumnNames4AdditionalParameters(this.additionalColumns.names.getValue());
        setting.setSqlExpressions4AdditionalParameters(this.additionalColumns.sqlExpressions.getValue());
        setting.setPositions4AdditionalParameters(this.additionalColumns.positions.getValue());
        setting.setReferenceColumns4AdditionalParameters(this.additionalColumns.referenceColumns.getValue());
        setting.setEnableFieldOptions((Boolean)this.enableFieldOptions.getValue());
        setting.setSchemaColumns4FieldOption(this.fieldOptions.schemaColumns.getValue());
        setting.setInsertable4FieldOption(this.fieldOptions.insertable.getValue());
        setting.setUpdatable4FieldOption(this.fieldOptions.updatable.getValue());
        setting.setUpdateKey4FieldOption(this.fieldOptions.updateKey.getValue());
        setting.setDeletionKey4FieldOption(this.fieldOptions.deletionKey.getValue());
        return setting;
    }

    private class FieldOption {
        String fieldName;
        boolean insertable;
        boolean updatable;

        private FieldOption() {
        }
    }

    public static enum DataAction {
        INSERT,
        UPDATE,
        INSERT_OR_UPDATE,
        UPDATE_OR_INSERT,
        DELETE;

    }
}

