/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jpmml.evaluator.CollectionValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.functions.BinaryFunction;

public class SplitFunction
extends BinaryFunction {
    public SplitFunction() {
        this(SplitFunction.class.getName());
    }

    public SplitFunction(String name) {
        super(name, Arrays.asList("input", "pattern"));
    }

    public List<String> evaluate(String input, String regex) {
        Pattern pattern = RegExUtil.compile((String)regex, null);
        String[] values = pattern.split(input, -1);
        return Arrays.asList(values);
    }

    public FieldValue evaluate(FieldValue first, FieldValue second) {
        List<String> values = this.evaluate(first.asString(), second.asString());
        return CollectionValue.create((TypeInfo)TypeInfos.CATEGORICAL_STRING, values);
    }
}

