/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.enforcer;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.codegen.enforcer.IndexMapper;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class OutgoingSchemaEnforcer
implements IndexedRecord {
    protected final Schema designSchema;
    protected final List<Schema.Field> designFields;
    protected final int designSchemaSize;
    protected IndexedRecord wrappedRecord;
    protected final IndexMapper indexMapper;
    protected int[] indexMap;
    private boolean firstRecordProcessed = false;

    public OutgoingSchemaEnforcer(Schema designSchema, IndexMapper indexMapper) {
        this.designSchema = designSchema;
        this.designFields = designSchema.getFields();
        this.designSchemaSize = this.designFields.size();
        this.indexMapper = indexMapper;
    }

    public void setWrapped(IndexedRecord record) {
        this.wrappedRecord = record;
        if (!this.firstRecordProcessed) {
            this.indexMap = this.indexMapper.computeIndexMap(record.getSchema());
            this.firstRecordProcessed = true;
        }
    }

    public Schema getSchema() {
        return this.designSchema;
    }

    public void put(int i, Object v) {
        throw new IndexedRecordConverter.UnmodifiableAdapterException();
    }

    public Object get(int pojoIndex) {
        Schema.Field outField = this.designFields.get(pojoIndex);
        Object value = this.wrappedRecord.get(this.indexMap[pojoIndex]);
        return this.transformValue(value, outField);
    }

    protected Object transformValue(Object value, Schema.Field valueField) {
        if (null == value) {
            return null;
        }
        Schema nonnull = AvroUtils.unwrapIfNullable((Schema)valueField.schema());
        LogicalType logicalType = nonnull.getLogicalType();
        if (logicalType != null) {
            if (logicalType == LogicalTypes.date()) {
                LocalDate ld = LocalDate.ofEpochDay(((Integer)value).longValue());
                ZonedDateTime zonedDate = ld.atStartOfDay(ZoneId.systemDefault());
                return Date.from(zonedDate.toInstant());
            }
            if (logicalType == LogicalTypes.timeMillis()) {
                if ("TALEND_DATE".equals(valueField.getProp("LOGICAL_TIME_TYPE_AS"))) {
                    return new Date(((Integer)value).intValue());
                }
                return value;
            }
            if (logicalType == LogicalTypes.timestampMillis()) {
                return new Date((Long)value);
            }
        }
        String talendType = valueField.getProp("di.column.talendType");
        String javaClass = nonnull.getProp("java-class");
        if ("id_Short".equals(talendType)) {
            return value instanceof Number ? ((Number)value).shortValue() : Short.parseShort(String.valueOf(value));
        }
        if ("id_Date".equals(talendType) || "java.util.Date".equals(javaClass)) {
            return value instanceof Date ? value : new Date((Long)value);
        }
        if ("id_Byte".equals(talendType)) {
            return value instanceof Number ? ((Number)value).byteValue() : Byte.parseByte(String.valueOf(value));
        }
        if ("id_Character".equals(talendType) || "java.lang.Character".equals(javaClass)) {
            return value instanceof Character ? value : Character.valueOf(((String)value).charAt(0));
        }
        if ("id_BigDecimal".equals(talendType) || "java.math.BigDecimal".equals(javaClass)) {
            return value instanceof BigDecimal ? value : new BigDecimal(String.valueOf(value));
        }
        return value;
    }
}

