/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.enforcer;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.codegen.enforcer.DynamicIndexMapper;
import org.talend.daikon.avro.AvroUtils;

class DynamicIndexMapperByIndex
implements DynamicIndexMapper {
    private final int designSchemaSize;
    private final int dynamicFieldPosition;

    DynamicIndexMapperByIndex(Schema designSchema) {
        this.designSchemaSize = designSchema.getFields().size();
        String dynamicFieldProperty = designSchema.getProp("di.dynamic.column.position");
        if (!AvroUtils.isIncludeAllFields((Schema)designSchema) || dynamicFieldProperty == null) {
            throw new IllegalArgumentException("Design schema doesn't contain dynamic field");
        }
        this.dynamicFieldPosition = Integer.valueOf(dynamicFieldProperty);
    }

    @Override
    public int[] computeIndexMap(Schema runtimeSchema) {
        int runtimeSchemaSize = runtimeSchema.getFields().size();
        int dynamicFieldsNumber = runtimeSchemaSize - this.designSchemaSize;
        int[] indexMap = new int[this.designSchemaSize + 1];
        for (int i = 0; i < this.designSchemaSize + 1; ++i) {
            if (i == this.dynamicFieldPosition) {
                indexMap[this.dynamicFieldPosition] = -1;
                continue;
            }
            indexMap[i] = i < this.dynamicFieldPosition ? i : dynamicFieldsNumber + i - 1;
        }
        return indexMap;
    }

    @Override
    public List<Integer> computeDynamicFieldsIndexes(Schema runtimeSchema) {
        int runtimeSchemaSize = runtimeSchema.getFields().size();
        int dynamicFieldsNumber = runtimeSchemaSize - this.designSchemaSize;
        ArrayList<Integer> dynamicFieldsIndexes = new ArrayList<Integer>(dynamicFieldsNumber);
        for (int i = 0; i < dynamicFieldsNumber; ++i) {
            int dynamicFieldIndex = this.dynamicFieldPosition + i;
            dynamicFieldsIndexes.add(dynamicFieldIndex);
        }
        return dynamicFieldsIndexes;
    }
}

