package cz.drg.clasificator.writers;

import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.OutputHelper;
import java.util.List;

public class SystemOutWriter extends BaseWriter{

    static{loadDefaults();}
    
    private static String DEFAULT_DELIMITER;
    
    public SystemOutWriter(String delimiter) {
        super(delimiter);
    }

    public SystemOutWriter() {
        super(DEFAULT_DELIMITER);
    }
    
    /**
     * Init class default values. This expects settings to be loaded before use.
     */
    private static void loadDefaults(){
        ProgramSettings programSettings = Settings.getProgramSettings();
        
        DEFAULT_DELIMITER = programSettings.getDefaultDelimiter();
    }
    
    @Override
    public void writeOutput(List<String> lines) {
        
        for (String line : lines) {
            
            OutputHelper.dualLog(line);
            
        }
        
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
