package cz.drg.clasificator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.IOException;
import org.dmg.pmml.PMML;

/**
 *
 * @author jirasek
 */
public class UnmarshallNormaly {
    
    public PMML unmarshal(File pmmlFile){
        try {
            return unmarshal(new FileInputStream(pmmlFile));
        } catch (FileNotFoundException ex) {
            Logger.getLogger(UnmarshallNormaly.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
    
    
    public PMML unmarshal(InputStream pmmlFile){
        
        PMML pmml = null;
        
        try {
            pmml = JacksonUtil.mapper().readValue(pmmlFile, PMML.class);
        } 
        catch (IOException ex) {
            Logger.getLogger(UnmarshallNormaly.class.getName()).log(Level.SEVERE, null, ex);
        }
                    
        return pmml;
    }
    
//    private PMML unmarshal(Unmarshaller unmarshaller, InputStream inputStream) throws JAXBException{
//        return (PMML)unmarshaller.unmarshal(inputStream);
//    }
    
}
