package cz.drg.clasificator.util;

import cz.drg.clasificator.setting.program.IOclass;
import cz.drg.clasificator.util.InsertQuery.DatabaseType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * @author jiras
 */
public class InsertQueryBatch {
    
    private List<InsertQuery> queries;
    private IOclass ioClass;
    
    public InsertQueryBatch(IOclass ioClass) {
        queries = new ArrayList<>();
        
        if(ioClass == null){
            throw new IllegalArgumentException("IOClass parameter '"+ioClass+"' is invalid!");
        }
        
        this.ioClass = ioClass;
    }
    
    public Statement fillStatement(Statement statement) throws SQLException{
        
        for (InsertQuery query : queries) {
            statement.addBatch(query.toString());
        }
        
        return statement;
    }
    
    public void createQueries(HeaderList originalInput, List<List<String>> evaluatedOutput){
        
        List<String> headers = getHeaders(originalInput, evaluatedOutput);
        List<List<String>> values = getValues(originalInput, evaluatedOutput);
        
        
        for (List<String> row : values) {
            
            InsertQuery query = new InsertQuery(getTargetTable());
            query.setHeaders(headers);
            query.setValues(row);
            
            prepareForSpecificDbVendors(query);
            
            queries.add(query);
        }
        
    }
    
    private List<String> getHeaders(HeaderList originalInput, List<List<String>> evaluatedOutput){
        
        List<List<String>> values = originalInput.getValues();
        List<String> headers = new ArrayList<>();
        
        headers.addAll(values.get(0).stream().map(value -> value.replaceAll("\"", "")).collect(Collectors.toList()));
        headers.addAll(evaluatedOutput.get(0));
        
        return headers;
    }
    
    private List<List<String>> getValues(HeaderList originalInput, List<List<String>> evaluatedOutput){
    
        List<List<String>> originalValues = originalInput.getValues();
        List<List<String>> allValues = new ArrayList<>();
        
        for (int i = 1; i <= originalInput.numOfLines(); i++) {
            List<String> row = new ArrayList<>();
            
            row.addAll(originalValues.get(i).stream().map(value -> value.replaceAll("\"", "")).collect(Collectors.toList()));
            row.addAll(evaluatedOutput.get(i));
            
            allValues.add(row);
        }
        
        return allValues;
    }
    
    private String getTargetTable(){
        return ioClass.getDatabaseTargetTable();
    }
    
    private void prepareForSpecificDbVendors(InsertQuery query){
        //oracle has some specific ways of batch INSERT
        if(ioClass.getDatabaseConnection().contains("jdbc:oracle:thin:@")){
            query.setDbType(DatabaseType.ORACLE);
        }
        else if(ioClass.getDatabaseConnection().contains("jdbc:informix-sqli:")){
            query.setDbType(DatabaseType.INFORMIX);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        
        for (InsertQuery query : queries) {
            sb.append(query);
            sb.append("\n");
        }
        
        return "InsertQueryBatch{\n" + sb + '}';
    }
    
    
}
