package cz.drg.clasificator.util;

import java.util.List;
import java.util.Map;

/**
 * This interface is used in HeaderList class to easily populate HeaderList with
 * data provided by this reader.
 * 
 * @author Pavel Jirasek
 */
public interface HeaderListReader {
    
    /**
     * Returns map of column names to its indexes. 
     * @return 
     */
    public Map<String, Integer> getHeadersWithIndexes();
    
    /**
     * Returns list of all collumns of read data.
     * @return 
     */
    public List<List<String>> getColumnLists();

    /**
     * Returns number of lines read by the reader.
     * @return 
     */
    public int getNumberOfLines();

}
