package cz.drg.clasificator.args.argevaluation;

import cz.drg.clasificator.args.ProgramExecutor;

/**
 * Interface for argument/parameter evaluator used in EvaluatorFactory for loose
 * connection of the two and if needed easy change of the Evaluator implementation.
 * 
 * @author Pavel Jirasek
 */
public interface Evaluator {
    
    /**
     * Evaluate user inputed arguments and their parameters. 
     * 
     * @param visitor visitor instance for control over the application from evaluator
     */
    public void evaluate(ProgramExecutor visitor);
    
    /**
     * Add new parameter to current argument.
     * 
     * @param param value of parameter
     */
    public void addParameter(String param);
    
    public Evaluator clearParameters();
    
}
