package cz.drg.clasificator.args.argevaluation;

import cz.drg.clasificator.args.ProgramExecutor;
import cz.drg.clasificator.util.Constants;

/**
 * Dummy evaluator used in case no evaluator was found in the factory usually due to the fact
 * that passed value was not supported. This evaluator will stop execution of the program
 * upon calling its evaluate function.
 * 
 * @author Pavel Jirasek
 */
public class ArgNotFoundEvaluator extends ArgEvaluator{

    public ArgNotFoundEvaluator(String arg) {
        super(arg);
    }

    @Override
    public void evaluate(ProgramExecutor visitor) {
        visitor.stopExecution(String.format(Constants.ERR_ARG_NOT_SUPPORTED, argument));
    }

}
