package cz.drg.clasificator.args.argevaluation;

import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.setting.program.Arguments.Argument;
import java.util.HashMap;
import java.util.Map;

/**
 * Implementation of EvaluatorFactory interface used to get correct evaluator for 
 * specified user inputted program argument.
 * Use the returned evaluator to evaluate and control program flow like defining specific
 * reader/writer based on user input.
 * 
 * @author Pavel Jirasek
 */
public class ArgEvaluatorFactory implements EvaluatorFactory{
    
    private Map<String, Evaluator> map = new HashMap<>();

    public ArgEvaluatorFactory() {
        init();
    }
    
    private void init(){
        ProgramSettings programSettings = Settings.getProgramSettings();
        
        for (Argument argument : programSettings.getArguments()) {
            map.put(argument.getValue(), new ArgEvaluator(argument.getValue()));
        }
    }
    
    @Override
    public Evaluator getEvaluator(String name) {
        return map.getOrDefault(name, new ArgNotFoundEvaluator(name)).clearParameters();
    }

}
