package cz.drg.clasificator;

import cz.drg.clasificator.util.JvmMonitor;
import cz.drg.clasificator.args.CZDRGExecutor;
import cz.drg.clasificator.args.CZDRGServiceExecutor;
import cz.drg.clasificator.args.ProgramExecutor;
import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.util.FilesCache;
import cz.drg.clasificator.util.OutputHelper;

public class Main{ 

    public static void main(String[] args) {
        JvmMonitor jvmMonitor = new JvmMonitor();
        jvmMonitor.registerForMemUsageChanges();
        Runtime.getRuntime().addShutdownHook(new Thread(FilesCache::removeAllCachedFiles));
        
        ProgramExecutor exec = new CZDRGExecutor();
        
        if(args.length > 0 && args[0].equals("-service")){
            exec = new CZDRGServiceExecutor();
        }
        
        try{
            exec.execute(args);
        }
        catch(ShutdownException ex){
            OutputHelper.dualLog(ex.getMessage());
            OutputHelper.dualLog("Program will shutdown.");
            System.exit(1);
        }
    }
    
}
