package cz.drg.clasificator;

import static cz.drg.clasificator.util.OutputHelper.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Pavel Jirasek
 */
public class CZDRGClasificatorService extends CZDRGClasificator{

    private String currentCaseId;
    
    @Override
    protected void logResult(long evaluationStartTime, long readLines, long writtenLines, long errorLines, long noClasificationLines) {
        double timeElapsedSec = (System.currentTimeMillis() - evaluationStartTime) / 1000.0;
        
        DateFormat format = new SimpleDateFormat("dd.MM.yyyy H:mm:ss");
        dualLog(String.format("%s - Case '%s' evaluated after %.3f sec", format.format(new Date()), currentCaseId, timeElapsedSec));
    }
    
    public void setCurentCaseId(String currentCaseId){
        this.currentCaseId = currentCaseId;
    }
}
