/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Util;

public class RelJson {
    private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();
    private final JsonBuilder jsonBuilder;
    public static final List<String> PACKAGES = ImmutableList.of((Object)"org.apache.calcite.rel.", (Object)"org.apache.calcite.rel.core.", (Object)"org.apache.calcite.rel.logical.", (Object)"org.apache.calcite.adapter.jdbc.", (Object)"org.apache.calcite.adapter.jdbc.JdbcRules$");

    public RelJson(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    public RelNode create(Map<String, Object> map) {
        String type = (String)map.get("type");
        Constructor constructor = this.getConstructor(type);
        try {
            return (RelNode)constructor.newInstance(map);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
    }

    public Constructor getConstructor(String type) {
        Constructor constructor = this.constructorMap.get(type);
        if (constructor == null) {
            Class clazz = this.typeNameToClass(type);
            try {
                constructor = clazz.getConstructor(RelInput.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class does not have required constructor, " + clazz + "(RelInput)");
            }
            this.constructorMap.put(type, constructor);
        }
        return constructor;
    }

    public Class typeNameToClass(String type) {
        if (!type.contains(".")) {
            for (String package_ : PACKAGES) {
                try {
                    return Class.forName(package_ + type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unknown type " + type);
        }
    }

    public String classToTypeName(Class<? extends RelNode> class_) {
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    public Object toJson(RelCollationImpl node) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map<String, Object> map = this.jsonBuilder.map();
            map.put("field", fieldCollation.getFieldIndex());
            map.put("direction", fieldCollation.getDirection().name());
            map.put("nulls", fieldCollation.nullDirection.name());
            list.add(map);
        }
        return list;
    }

    public RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (Map<String, Object> map : jsonFieldCollations) {
            fieldCollations.add(this.toFieldCollation(map));
        }
        return RelCollations.of(fieldCollations);
    }

    public RelFieldCollation toFieldCollation(Map<String, Object> map) {
        Integer field = (Integer)map.get("field");
        RelFieldCollation.Direction direction = (RelFieldCollation.Direction)((Object)Util.enumVal(RelFieldCollation.Direction.class, (String)map.get("direction")));
        RelFieldCollation.NullDirection nullDirection = (RelFieldCollation.NullDirection)((Object)Util.enumVal(RelFieldCollation.NullDirection.class, (String)map.get("nulls")));
        return new RelFieldCollation(field, direction, nullDirection);
    }

    public RelDistribution toDistribution(Object o) {
        return RelDistributions.ANY;
    }

    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                ((RelDataTypeFactory.Builder)builder).add((String)jsonMap.get("name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        Map map = (Map)o;
        SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map.get("type")));
        Integer precision = (Integer)map.get("precision");
        Integer scale = (Integer)map.get("scale");
        RelDataType type = precision == null ? typeFactory.createSqlType(sqlTypeName) : (scale == null ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName, precision, scale));
        boolean nullable = (Boolean)map.get("nullable");
        return typeFactory.createTypeWithNullability(type, nullable);
    }

    public Object toJson(AggregateCall node) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("agg", this.toJson(node.getAggregation()));
        map.put("type", this.toJson(node.getType()));
        map.put("distinct", node.isDistinct());
        map.put("operands", node.getArgList());
        return map;
    }

    Object toJson(Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof RexNode) {
            return this.toJson((RexNode)value);
        }
        if (value instanceof CorrelationId) {
            return this.toJson((CorrelationId)value);
        }
        if (value instanceof List) {
            List<Object> list = this.jsonBuilder.list();
            for (Object o : (List)value) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value instanceof ImmutableBitSet) {
            List<Object> list = this.jsonBuilder.list();
            for (Integer integer : (ImmutableBitSet)value) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value instanceof AggregateCall) {
            return this.toJson((AggregateCall)value);
        }
        if (value instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        throw new UnsupportedOperationException("type not serializable: " + value + " (type " + value.getClass().getCanonicalName() + ")");
    }

    private Object toJson(RelDataType node) {
        if (node.isStruct()) {
            List<Object> list = this.jsonBuilder.list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            return list;
        }
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("type", node.getSqlTypeName().name());
        map.put("nullable", node.isNullable());
        if (node.getSqlTypeName().allowsPrec()) {
            map.put("precision", node.getPrecision());
        }
        if (node.getSqlTypeName().allowsScale()) {
            map.put("scale", node.getScale());
        }
        return map;
    }

    private Object toJson(RelDataTypeField node) {
        Map map = (Map)this.toJson(node.getType());
        map.put("name", node.getName());
        return map;
    }

    private Object toJson(CorrelationId node) {
        return node.getId();
    }

    private Object toJson(RexNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS: {
                Map<String, Object> map = this.jsonBuilder.map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map.put("field", fieldAccess.getField().getName());
                map.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value2 = literal.getValue2();
                if (value2 == null) {
                    Map<String, Object> map = this.jsonBuilder.map();
                    map.put("literal", null);
                    map.put("type", literal.getTypeName().name());
                    return map;
                }
                return value2;
            }
            case INPUT_REF: 
            case LOCAL_REF: {
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                return map;
            }
            case CORREL_VARIABLE: {
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("correl", ((RexCorrelVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, Object> map = this.jsonBuilder.map();
            map.put("op", this.toJson(call.getOperator()));
            List<Object> list = this.jsonBuilder.list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map.put("operands", list);
            switch (node.getKind()) {
                case CAST: {
                    map.put("type", this.toJson(node.getType()));
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                map.put("class", call.getOperator().getClass().getName());
            }
            return map;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    RexNode toRex(RelInput relInput, Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            String op = (String)map.get("op");
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (op != null) {
                List operands = (List)map.get("operands");
                Object jsonType = map.get("type");
                SqlOperator operator = this.toOp(op, map);
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                RelDataType type = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type, operator, rexOperands);
            }
            Integer input = (Integer)map.get("input");
            if (input != null) {
                List<RelNode> inputNodes = relInput.getInputs();
                int i = input;
                for (RelNode inputNode : inputNodes) {
                    RelDataType rowType = inputNode.getRowType();
                    if (i < rowType.getFieldCount()) {
                        RelDataTypeField field = rowType.getFieldList().get(i);
                        return rexBuilder.makeInputRef(field.getType(), (int)input);
                    }
                    i -= rowType.getFieldCount();
                }
                throw new RuntimeException("input field " + input + " is out of range");
            }
            String field = (String)map.get("field");
            if (field != null) {
                Object jsonExpr = map.get("expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map.get("correl");
            if (correl != null) {
                Object jsonType = map.get("type");
                RelDataType type = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type, new CorrelationId(correl));
            }
            if (map.containsKey("literal")) {
                Object literal = map.get("literal");
                SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map.get("type")));
                if (literal == null) {
                    return rexBuilder.makeNullLiteral(typeFactory.createSqlType(sqlTypeName));
                }
                return this.toRex(relInput, literal);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    private SqlOperator toOp(String op, Map<String, Object> map) {
        List<SqlOperator> operatorList = SqlStdOperatorTable.instance().getOperatorList();
        for (SqlOperator operator : operatorList) {
            if (!operator.getName().equals(op)) continue;
            return operator;
        }
        String class_ = (String)map.get("class");
        if (class_ != null) {
            return (SqlOperator)AvaticaUtils.instantiatePlugin(SqlOperator.class, (String)class_);
        }
        return null;
    }

    SqlAggFunction toAggregation(String agg, Map<String, Object> map) {
        return (SqlAggFunction)this.toOp(agg, map);
    }

    private String toJson(SqlOperator operator) {
        return operator.getName();
    }
}

