/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.flowvariables.runtime;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.codegen.flowvariables.runtime.DataProcessor;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.common.avro.RootSchemaUtils;

public class FlowVariablesProcessor
extends DataProcessor {
    private final RuntimeContainer runtimeContainer;
    private Schema flowVariablesSchema;

    FlowVariablesProcessor(RuntimeContainer runtimeContainer) {
        this.runtimeContainer = runtimeContainer;
    }

    void initSchema(IndexedRecord rootRecord) {
        if (this.flowVariablesSchema == null) {
            Schema rootSchema = rootRecord.getSchema();
            this.flowVariablesSchema = RootSchemaUtils.getOutOfBandSchema((Schema)rootSchema);
        }
    }

    private Object processRootRecord(IndexedRecord rootRecord) {
        Object mainData = rootRecord.get(0);
        IndexedRecord flowVariablesRecord = (IndexedRecord)rootRecord.get(1);
        String componentId = this.runtimeContainer.getCurrentComponentId();
        for (Schema.Field field : this.flowVariablesSchema.getFields()) {
            String flowVariableKey = field.name();
            int fieldPos = field.pos();
            Object flowVariableValue = flowVariablesRecord.get(fieldPos);
            this.runtimeContainer.setComponentData(componentId, flowVariableKey, flowVariableValue);
        }
        return mainData;
    }

    @Override
    Object processData(Object data) {
        IndexedRecord rootRecord = (IndexedRecord)data;
        return this.processRootRecord(rootRecord);
    }

    @Override
    Iterable<Object> processDataIterable(Iterable<Object> dataIterable) {
        Object mainData;
        IndexedRecord rootRecord;
        LinkedList<Object> mainDataList = new LinkedList<Object>();
        Iterator<Object> dataIterator = dataIterable.iterator();
        if (dataIterator.hasNext()) {
            rootRecord = (IndexedRecord)dataIterator.next();
            mainData = this.processRootRecord(rootRecord);
            mainDataList.add(mainData);
        }
        while (dataIterator.hasNext()) {
            rootRecord = (IndexedRecord)dataIterator.next();
            mainData = rootRecord.get(0);
            mainDataList.add(mainData);
        }
        return mainDataList;
    }
}

