/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.enforcer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.codegen.enforcer.DynamicIndexMapper;
import org.talend.codegen.enforcer.OutgoingSchemaEnforcer;
import org.talend.daikon.avro.AvroUtils;

public class OutgoingDynamicSchemaEnforcer
extends OutgoingSchemaEnforcer {
    private List<Schema.Field> runtimeFields;
    private final int dynamicFieldPosition;
    private List<Integer> dynamicFieldsIndexes;
    private Schema dynamicFieldsSchema;
    private boolean firstRecordProcessed = false;

    public OutgoingDynamicSchemaEnforcer(Schema designSchema, DynamicIndexMapper indexMapper) {
        super(designSchema, indexMapper);
        if (!AvroUtils.isIncludeAllFields((Schema)designSchema)) {
            throw new IllegalArgumentException("Design schema doesn't contain dynamic field");
        }
        this.dynamicFieldPosition = Integer.valueOf(designSchema.getProp("di.dynamic.column.position"));
    }

    public Schema getDynamicFieldsSchema() {
        return this.dynamicFieldsSchema;
    }

    @Override
    public Object get(int pojoIndex) {
        int runtimeIndex = this.indexMap[pojoIndex];
        if (runtimeIndex == -2) {
            return null;
        }
        if (runtimeIndex == -1) {
            return this.getDynamicValues();
        }
        Schema.Field designField = pojoIndex > this.dynamicFieldPosition ? (Schema.Field)this.designFields.get(pojoIndex - 1) : (Schema.Field)this.designFields.get(pojoIndex);
        Object value = this.wrappedRecord.get(runtimeIndex);
        return this.transformValue(value, designField);
    }

    @Override
    public void setWrapped(IndexedRecord record) {
        super.setWrapped(record);
        if (!this.firstRecordProcessed) {
            Schema runtimeSchema = record.getSchema();
            this.runtimeFields = runtimeSchema.getFields();
            this.dynamicFieldsIndexes = ((DynamicIndexMapper)this.indexMapper).computeDynamicFieldsIndexes(runtimeSchema);
            this.createDynamicFieldsSchema();
            this.firstRecordProcessed = true;
        }
    }

    private Map<String, Object> getDynamicValues() {
        LinkedHashMap<String, Object> dynamicValues = new LinkedHashMap<String, Object>();
        for (int dynamicIndex : this.dynamicFieldsIndexes) {
            Schema.Field dynamicField = this.runtimeFields.get(dynamicIndex);
            String dynamicFieldName = dynamicField.name();
            Object value = this.wrappedRecord.get(dynamicIndex);
            value = this.transformValue(value, this.runtimeFields.get(dynamicIndex));
            dynamicValues.put(dynamicFieldName, value);
        }
        return dynamicValues;
    }

    private void createDynamicFieldsSchema() {
        ArrayList<Schema.Field> dynamicFields = new ArrayList<Schema.Field>();
        for (int index : this.dynamicFieldsIndexes) {
            Schema.Field dynamicField = this.runtimeFields.get(index);
            Schema.Field dynamicFieldCopy = new Schema.Field(dynamicField.name(), dynamicField.schema(), dynamicField.doc(), dynamicField.defaultVal());
            Map fieldProperties = dynamicField.getObjectProps();
            for (Map.Entry entry : fieldProperties.entrySet()) {
                Object propValue = entry.getValue();
                if (propValue == null) continue;
                dynamicFieldCopy.addProp((String)entry.getKey(), propValue);
            }
            dynamicFields.add(dynamicFieldCopy);
        }
        this.dynamicFieldsSchema = Schema.createRecord((String)"dynamic", null, null, (boolean)false);
        this.dynamicFieldsSchema.setFields(dynamicFields);
    }
}

