/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.enforcer;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.LogicalTypeUtils;

public class IncomingSchemaEnforcer {
    private static final int NO_DYNAMIC_COLUMN = -1;
    private static final long ONE_DAY = 86400000L;
    private final Schema designSchema;
    private final int dynamicColumnPosition;
    private Schema runtimeSchema;
    private List<Schema.Field> dynamicFields = null;
    private List<Schema.Field> incomingFields = null;
    private GenericData.Record currentRecord = null;
    private final Map<String, Integer> columnToFieldIndex = new HashMap<String, Integer>();
    private final Map<String, SimpleDateFormat> dateFormatCache = new HashMap<String, SimpleDateFormat>();

    public IncomingSchemaEnforcer(Schema incoming) {
        this.designSchema = incoming;
        this.incomingFields = new ArrayList<Schema.Field>();
        int n = this.dynamicColumnPosition = AvroUtils.isIncludeAllFields((Schema)this.designSchema) ? Integer.valueOf(this.designSchema.getProp("di.dynamic.column.position")) : -1;
        if (this.dynamicColumnPosition != -1) {
            this.runtimeSchema = null;
            this.dynamicFields = new ArrayList<Schema.Field>();
        } else {
            this.runtimeSchema = this.designSchema;
        }
        for (Schema.Field f : this.designSchema.getFields()) {
            if (f.pos() == this.dynamicColumnPosition) continue;
            this.columnToFieldIndex.put(f.name(), f.pos());
        }
    }

    @Deprecated
    public void initDynamicColumn(String name, String dbName, String type, String dbType, int dbTypeId, int length, int precision, String format, String description, boolean isKey, boolean isNullable, String refFieldName, String refModuleName) {
        this.addDynamicField(name, type, null, format, description, isNullable);
    }

    public void addDynamicField(String name, String diType, String logicalType, String fieldPattern, String description, boolean isNullable) {
        if (!this.needsInitDynamicColumns()) {
            return;
        }
        Schema fieldSchema = this.diToAvro(diType, logicalType);
        if (isNullable) {
            fieldSchema = (Schema)SchemaBuilder.nullable().type(fieldSchema);
        }
        Schema.Field field = new Schema.Field(name, fieldSchema, description, null);
        if ("id_Date".equals(diType) && fieldPattern != null) {
            field.addProp("talend.field.pattern", fieldPattern);
        }
        this.dynamicFields.add(field);
    }

    public void addIncomingNodeField(String name, String className) {
        String diType = "id_String";
        switch (className) {
            case "java.lang.String": {
                diType = "id_String";
                break;
            }
            case "java.lang.Boolean": {
                diType = "id_Boolean";
                break;
            }
            case "java.lang.Integer": {
                diType = "id_Integer";
                break;
            }
            case "java.lang.Long": {
                diType = "id_Long";
                break;
            }
            case "java.lang.Double": {
                diType = "id_Double";
                break;
            }
            case "java.lang.Float": {
                diType = "id_Float";
                break;
            }
            case "java.lang.Byte": {
                diType = "id_Byte";
                break;
            }
            case "java.lang.Short": {
                diType = "id_Short";
                break;
            }
            case "java.lang.Character": {
                diType = "id_Character";
                break;
            }
            case "java.lang.BigDecimal": {
                diType = "id_BigDecimal";
                break;
            }
            case "java.lang.Date": {
                diType = "id_Date";
            }
            default: {
                diType = "id_String";
            }
        }
        Schema fieldSchema = this.diToAvro(diType, null);
        Schema.Field field = new Schema.Field(name, fieldSchema, "", null);
        this.incomingFields.add(field);
    }

    Schema diToAvro(String diType, String logicalType) {
        Schema fieldSchema = LogicalTypeUtils.getSchemaByLogicalType((String)logicalType);
        if (fieldSchema != null) {
            return fieldSchema;
        }
        if ("id_String".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        } else if ("id_Boolean".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        } else if ("id_Integer".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.INT);
        } else if ("id_Long".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        } else if ("id_Double".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        } else if ("id_Float".equals(diType)) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        } else if ("id_Byte".equals(diType)) {
            fieldSchema = AvroUtils._byte();
        } else if ("id_Short".equals(diType)) {
            fieldSchema = AvroUtils._short();
        } else if ("id_Character".equals(diType)) {
            fieldSchema = AvroUtils._character();
        } else if ("id_BigDecimal".equals(diType)) {
            fieldSchema = AvroUtils._decimal();
        } else if ("id_Date".equals(diType)) {
            fieldSchema = AvroUtils._date();
        } else {
            throw new UnsupportedOperationException("Unrecognized type " + diType);
        }
        return fieldSchema;
    }

    @Deprecated
    public void initDynamicColumnsFinished() {
        this.createRuntimeSchema();
    }

    public void createRuntimeSchema() {
        if (this.areDynamicFieldsInitialized() && this.incomingFields.size() == 0) {
            return;
        }
        boolean dynamicFieldsAdded = false;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field designField : this.designSchema.getFields()) {
            if (designField.pos() == this.dynamicColumnPosition) {
                fields.addAll(this.dynamicFields);
                dynamicFieldsAdded = true;
            }
            Schema.Field designFieldCopy = this.copyField(designField);
            fields.add(designFieldCopy);
        }
        fields.addAll(this.incomingFields);
        if (!dynamicFieldsAdded && this.dynamicFields != null) {
            fields.addAll(this.dynamicFields);
        }
        this.runtimeSchema = Schema.createRecord((String)this.designSchema.getName(), (String)this.designSchema.getDoc(), (String)this.designSchema.getNamespace(), (boolean)this.designSchema.isError());
        this.runtimeSchema.setFields(fields);
        for (Schema.Field f : this.runtimeSchema.getFields()) {
            this.columnToFieldIndex.put(f.name(), f.pos());
        }
        this.incomingFields.clear();
        this.dynamicFields = null;
    }

    private Schema.Field copyField(Schema.Field original) {
        Schema.Field copy = new Schema.Field(original.name(), original.schema(), original.doc(), original.defaultVal());
        for (Map.Entry e : original.getObjectProps().entrySet()) {
            copy.addProp((String)e.getKey(), e.getValue());
        }
        return copy;
    }

    @Deprecated
    public boolean needsInitDynamicColumns() {
        return !this.areDynamicFieldsInitialized();
    }

    public boolean areDynamicFieldsInitialized() {
        return this.dynamicFields == null;
    }

    public Schema getRuntimeSchema() {
        return this.runtimeSchema;
    }

    public Schema getDesignSchema() {
        return this.designSchema;
    }

    public void put(String name, Object diValue) {
        this.put(this.columnToFieldIndex.get(name), diValue);
    }

    public void put(int index, Object diValue) {
        Date diDate;
        if (this.currentRecord == null) {
            this.createNewRecord();
        }
        if (diValue == null) {
            this.currentRecord.put(index, null);
            return;
        }
        Schema.Field field = (Schema.Field)this.runtimeSchema.getFields().get(index);
        Schema fieldSchema = AvroUtils.unwrapIfNullable((Schema)field.schema());
        Object avroValue = null;
        String talendType = field.getProp("di.column.talendType");
        String javaClass = fieldSchema.getProp("java-class");
        if ("java.util.Date".equals(javaClass) || "id_Date".equals(talendType)) {
            if (diValue instanceof Date) {
                avroValue = diValue;
            } else if (diValue instanceof Long) {
                avroValue = new Date((Long)diValue);
            } else if (diValue instanceof String) {
                SimpleDateFormat df;
                String pattern = field.getProp("talend.field.pattern");
                String vs = (String)diValue;
                if (pattern == null || pattern.equals("yyyy-MM-dd'T'HH:mm:ss'000Z'")) {
                    if (!vs.endsWith("000Z")) {
                        throw new RuntimeException("Unparseable date: \"" + vs + "\"");
                    }
                    pattern = "yyyy-MM-dd'T'HH:mm:ss";
                }
                if ((df = this.dateFormatCache.get(pattern)) == null) {
                    df = new SimpleDateFormat(pattern);
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    this.dateFormatCache.put(pattern, df);
                }
                try {
                    avroValue = df.parse((String)diValue);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (LogicalTypeUtils.isLogicalDate((Schema)fieldSchema)) {
            diDate = (Date)diValue;
            OffsetDateTime odt = LocalDateTime.ofInstant(diDate.toInstant(), ZoneId.systemDefault()).atOffset(ZoneOffset.UTC);
            int avroDays = (int)ChronoUnit.DAYS.between(Instant.EPOCH, odt);
            this.currentRecord.put(index, (Object)avroDays);
            return;
        }
        if (LogicalTypeUtils.isLogicalTimestampMillis((Schema)fieldSchema)) {
            diDate = (Date)diValue;
            long avroTimestamp = diDate.getTime();
            this.currentRecord.put(index, (Object)avroTimestamp);
            return;
        }
        if (LogicalTypeUtils.isLogicalTimeMillis((Schema)fieldSchema)) {
            this.currentRecord.put(index, diValue);
            return;
        }
        if ("id_BigDecimal".equals(talendType) || "java.math.BigDecimal".equals(javaClass)) {
            if (diValue instanceof BigDecimal) {
                avroValue = diValue;
            } else if (diValue instanceof String) {
                avroValue = new BigDecimal((String)diValue);
            }
        }
        if (avroValue == null) {
            switch (fieldSchema.getType()) {
                case ARRAY: {
                    break;
                }
                case BOOLEAN: {
                    if (diValue instanceof Boolean) {
                        avroValue = diValue;
                        break;
                    }
                    avroValue = Boolean.valueOf(String.valueOf(diValue));
                    break;
                }
                case FIXED: 
                case BYTES: {
                    if (diValue instanceof byte[] || "java.lang.Object".equals(javaClass)) {
                        avroValue = diValue;
                        break;
                    }
                    avroValue = String.valueOf(diValue).getBytes();
                    break;
                }
                case DOUBLE: {
                    if (diValue instanceof Number) {
                        avroValue = ((Number)diValue).doubleValue();
                        break;
                    }
                    avroValue = Double.valueOf(String.valueOf(diValue));
                    break;
                }
                case ENUM: {
                    break;
                }
                case FLOAT: {
                    if (diValue instanceof Number) {
                        avroValue = Float.valueOf(((Number)diValue).floatValue());
                        break;
                    }
                    avroValue = Float.valueOf(String.valueOf(diValue));
                    break;
                }
                case INT: {
                    if (diValue instanceof Number) {
                        avroValue = ((Number)diValue).intValue();
                        break;
                    }
                    avroValue = Integer.valueOf(String.valueOf(diValue));
                    break;
                }
                case LONG: {
                    if (diValue instanceof Number) {
                        avroValue = ((Number)diValue).longValue();
                        break;
                    }
                    avroValue = Long.valueOf(String.valueOf(diValue));
                    break;
                }
                case MAP: {
                    break;
                }
                case NULL: {
                    avroValue = null;
                    break;
                }
                case RECORD: {
                    break;
                }
                case STRING: {
                    avroValue = String.valueOf(diValue);
                    break;
                }
                case UNION: {
                    break;
                }
            }
        }
        this.currentRecord.put(index, avroValue);
    }

    public IndexedRecord createIndexedRecord() {
        GenericData.Record copy = this.currentRecord;
        this.currentRecord = null;
        return copy;
    }

    public IndexedRecord getCurrentRecord() {
        return this.currentRecord;
    }

    public void createNewRecord() {
        this.currentRecord = new GenericData.Record(this.getRuntimeSchema());
    }
}

