/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.enforcer;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.codegen.enforcer.DynamicIndexMapper;
import org.talend.daikon.avro.AvroUtils;

class DynamicIndexMapperByName
implements DynamicIndexMapper {
    private final Schema designSchema;
    private final List<Schema.Field> designFields;
    private final int designSchemaSize;
    private final int dynamicFieldPosition;

    DynamicIndexMapperByName(Schema designSchema) {
        this.designSchema = designSchema;
        this.designFields = designSchema.getFields();
        this.designSchemaSize = this.designFields.size();
        String dynamicFieldProperty = designSchema.getProp("di.dynamic.column.position");
        if (!AvroUtils.isIncludeAllFields((Schema)designSchema) || dynamicFieldProperty == null) {
            throw new IllegalArgumentException("Design schema doesn't contain dynamic field");
        }
        this.dynamicFieldPosition = Integer.valueOf(dynamicFieldProperty);
    }

    @Override
    public int[] computeIndexMap(Schema runtimeSchema) {
        int[] indexMap = new int[this.designSchemaSize + 1];
        indexMap[this.dynamicFieldPosition] = -1;
        for (int i = 0; i < this.designSchemaSize; ++i) {
            Schema.Field designField = this.designFields.get(i);
            String fieldName = designField.name();
            Schema.Field runtimeField = runtimeSchema.getField(fieldName);
            if (i < this.dynamicFieldPosition) {
                indexMap[i] = runtimeField != null ? runtimeField.pos() : -2;
                continue;
            }
            indexMap[i + 1] = runtimeField != null ? runtimeField.pos() : -2;
        }
        return indexMap;
    }

    @Override
    public List<Integer> computeDynamicFieldsIndexes(Schema runtimeSchema) {
        int runtimeSchemaSize = runtimeSchema.getFields().size();
        int dynamicFieldsNumber = runtimeSchemaSize - this.designSchemaSize;
        ArrayList<Integer> dynamicFieldsIndexes = new ArrayList<Integer>(dynamicFieldsNumber);
        for (Schema.Field runtimeField : runtimeSchema.getFields()) {
            String fieldName = runtimeField.name();
            Schema.Field designField = this.designSchema.getField(fieldName);
            if (designField != null) continue;
            dynamicFieldsIndexes.add(runtimeField.pos());
        }
        return dynamicFieldsIndexes;
    }
}

