/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.converter;

import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.LogicalTypeUtils;

public final class TypeConverter {
    public static final String BOOLEAN = "id_Boolean";
    public static final String BYTE = "id_Byte";
    public static final String BYTE_ARRAY = "id_byte[]";
    public static final String CHARACTER = "id_Character";
    public static final String DATE = "id_Date";
    public static final String DOUBLE = "id_Double";
    public static final String FLOAT = "id_Float";
    public static final String BIGDECIMAL = "id_BigDecimal";
    public static final String INTEGER = "id_Integer";
    public static final String LONG = "id_Long";
    public static final String SHORT = "id_Short";
    public static final String STRING = "id_String";
    public static final String LIST = "id_List";
    public static final String OBJECT = "id_Object";

    private TypeConverter() {
    }

    public static Schema diToAvro(String diType, String logicalType) {
        Schema fieldSchema = LogicalTypeUtils.getSchemaByLogicalType((String)logicalType);
        if (fieldSchema != null) {
            return fieldSchema;
        }
        switch (diType) {
            case "id_String": {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case "id_Boolean": {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case "id_Integer": {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case "id_Long": {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case "id_Double": {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case "id_Float": {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case "id_Byte": {
                return AvroUtils._byte();
            }
            case "id_Short": {
                return AvroUtils._short();
            }
            case "id_Character": {
                return AvroUtils._character();
            }
            case "id_BigDecimal": {
                return AvroUtils._decimal();
            }
            case "id_Date": {
                return AvroUtils._logicalTimestamp();
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + diType);
    }

    public static String avroToDi(Schema fieldSchema) {
        Schema typeSchema = AvroUtils.unwrapIfNullable((Schema)fieldSchema);
        String logicalType = LogicalTypeUtils.getLogicalTypeName((Schema)typeSchema);
        if (logicalType != null) {
            return TypeConverter.getDiByLogicalType(logicalType);
        }
        String javaClass = typeSchema.getProp("java-class");
        if (javaClass != null) {
            return TypeConverter.getDiByJavaClass(javaClass);
        }
        return TypeConverter.getDiByAvroType(typeSchema.getType());
    }

    private static String getDiByLogicalType(String logicalType) {
        switch (logicalType) {
            case "date": {
                return DATE;
            }
            case "time-micros": {
                return LONG;
            }
            case "time-millis": {
                return INTEGER;
            }
            case "timestamp-micros": {
                return DATE;
            }
            case "timestamp-millis": {
                return DATE;
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + logicalType);
    }

    private static String getDiByJavaClass(String javaClass) {
        switch (javaClass) {
            case "java.math.BigDecimal": {
                return BIGDECIMAL;
            }
            case "java.lang.Byte": {
                return BYTE;
            }
            case "java.lang.Character": {
                return CHARACTER;
            }
            case "java.lang.Short": {
                return SHORT;
            }
            case "java.util.Date": {
                return DATE;
            }
            case "java.lang.Object": {
                return OBJECT;
            }
        }
        throw new UnsupportedOperationException("Unrecognized java class " + javaClass);
    }

    private static String getDiByAvroType(Schema.Type type) {
        switch (type) {
            case ARRAY: {
                return LIST;
            }
            case BYTES: {
                return BYTE_ARRAY;
            }
            case INT: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new UnsupportedOperationException("Unsupported avro type " + type);
    }
}

