/*
 * Decompiled with CFR 0.152.
 */
package org.talend.codegen.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.talend.codegen.converter.BigDecimalStringDoubleConverter;
import org.talend.codegen.converter.ByteIntegerConverter;
import org.talend.codegen.converter.CharStringConverter;
import org.talend.codegen.converter.DateLogicalDateConverter;
import org.talend.codegen.converter.DateLogicalTimestampConverter;
import org.talend.codegen.converter.IdentityConverter;
import org.talend.codegen.converter.ShortIntegerConverter;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.LogicalTypeUtils;
import org.talend.daikon.avro.converter.AvroConverter;

public class DiConverters {
    private static final Map<String, AvroConverter> LOGICAL_CONVERTERS = new HashMap<String, AvroConverter>();
    private static final Map<String, AvroConverter> DI_TYPES_CONVERTERS;
    private static final Map<Schema.Type, AvroConverter> AVRO_TYPES_CONVERTERS;

    public static List<AvroConverter> initConverters(Schema recordSchema) {
        ArrayList<AvroConverter> converters = new ArrayList<AvroConverter>();
        List fields = recordSchema.getFields();
        for (Schema.Field field : fields) {
            Schema fieldSchema = AvroUtils.unwrapIfNullable((Schema)field.schema());
            AvroConverter converter = DiConverters.initConverter(fieldSchema);
            converters.add(converter);
        }
        return converters;
    }

    private static AvroConverter initConverter(Schema fieldSchema) {
        if (LogicalTypeUtils.getLogicalTypeName((Schema)fieldSchema) != null) {
            return LOGICAL_CONVERTERS.get(LogicalTypeUtils.getLogicalTypeName((Schema)fieldSchema));
        }
        if (fieldSchema.getProp("java-class") != null) {
            return DI_TYPES_CONVERTERS.get(fieldSchema.getProp("java-class"));
        }
        return AVRO_TYPES_CONVERTERS.get(fieldSchema.getType());
    }

    static {
        LOGICAL_CONVERTERS.put("date", (AvroConverter)new DateLogicalDateConverter());
        LOGICAL_CONVERTERS.put("time-millis", (AvroConverter)IdentityConverter.getInstance());
        LOGICAL_CONVERTERS.put("timestamp-millis", (AvroConverter)new DateLogicalTimestampConverter());
        DI_TYPES_CONVERTERS = new HashMap<String, AvroConverter>();
        DI_TYPES_CONVERTERS.put(BigDecimal.class.getCanonicalName(), (AvroConverter)new BigDecimalStringDoubleConverter());
        DI_TYPES_CONVERTERS.put(Byte.class.getCanonicalName(), (AvroConverter)new ByteIntegerConverter());
        DI_TYPES_CONVERTERS.put(Character.class.getCanonicalName(), (AvroConverter)new CharStringConverter());
        DI_TYPES_CONVERTERS.put(Short.class.getCanonicalName(), (AvroConverter)new ShortIntegerConverter());
        DI_TYPES_CONVERTERS.put(Date.class.getCanonicalName(), (AvroConverter)new DateLogicalTimestampConverter());
        AVRO_TYPES_CONVERTERS = new HashMap<Schema.Type, AvroConverter>();
        AVRO_TYPES_CONVERTERS.put(Schema.Type.ARRAY, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.BOOLEAN, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.BYTES, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.DOUBLE, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.FLOAT, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.INT, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.LONG, (AvroConverter)IdentityConverter.getInstance());
        AVRO_TYPES_CONVERTERS.put(Schema.Type.STRING, (AvroConverter)IdentityConverter.getInstance());
    }
}

