/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.CSMspwd;
import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataInputStream;
import com.informix.util.IfxErrMsg;
import java.io.BufferedInputStream;
import java.io.IOException;

public class CSMBufferedInputStream
extends BufferedInputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final int BLOCK_SIZE = 8;
    static final int SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataInputStream IfxIs = null;
    private byte[] messageArray;
    private byte[] decryptedDataBuf;
    private int decryptedDataBufSize;
    private int decryptedDataBufPos;
    private int decryptedDataBufLen;
    private String ClientLocale = null;

    public CSMBufferedInputStream(IfxDataInputStream Is, CSMspwd csm) {
        super(Is);
        this.CSMspwd = csm;
        this.IfxIs = Is;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    public CSMBufferedInputStream(IfxDataInputStream Is, int size, CSMspwd csm) {
        super(Is, size);
        this.CSMspwd = csm;
        this.IfxIs = Is;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int i = this.read(tmp, 0, 1);
        if (i != -1) {
            return tmp[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.decryptedDataBufLen < len) {
            this.fillDecryptedDataBuf(len);
        }
        return this.copyOutData(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.decryptedDataBufLen < (int)n) {
            this.fillDecryptedDataBuf((int)n);
        }
        int skipLen = this.decryptedDataBufLen < (int)n ? this.decryptedDataBufLen : (int)n;
        this.decryptedDataBufPos += skipLen;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= skipLen;
        return skipLen;
    }

    @Override
    public int available() throws IOException {
        int len = this.IfxIs.available();
        if (len > 0) {
            this.fillDecryptedDataBuf(len);
        }
        return this.decryptedDataBufLen;
    }

    private void fillDecryptedDataBuf(int len) throws IOException {
        short messageType = 0;
        boolean messageLen = false;
        boolean realDataLen = false;
        boolean ret = false;
        while (this.decryptedDataBufLen < len && (messageType = this.IfxIs.readShort()) != -1) {
            if (messageType == 3) {
                this.readInDataToken();
                continue;
            }
            throw new IOException("JCSM protocol error.");
        }
    }

    private void readInDataToken() throws IOException {
        try {
            short tokenLen = this.IfxIs.readShort();
            short realDataLen = this.IfxIs.readShort();
            int paddedDataLen = tokenLen - 2;
            this.messageArray = new byte[paddedDataLen];
            int lenRead = this.IfxIs.readFully(this.messageArray, 0, paddedDataLen);
            if (lenRead < paddedDataLen) {
                throw new IOException("JCSM protocol error.");
            }
            byte[] paddedData = new byte[paddedDataLen];
            this.CSMspwd.processInMessage(this.messageArray, paddedData);
            this.copyInData(paddedData, realDataLen);
        }
        catch (IfxASFException e) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
    }

    private void copyInData(byte[] b, int len) {
        int newLen = this.decryptedDataBufLen + len;
        if (newLen > this.decryptedDataBufSize) {
            byte[] newDecryptedDataBuf = new byte[newLen];
            this.decryptedDataBufSize = newLen;
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, newDecryptedDataBuf, 0, this.decryptedDataBufLen);
            System.arraycopy(b, 0, newDecryptedDataBuf, this.decryptedDataBufLen, len);
            this.decryptedDataBuf = newDecryptedDataBuf;
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = newLen;
        } else if (this.decryptedDataBufPos + newLen >= this.decryptedDataBufSize) {
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, this.decryptedDataBuf, 0, this.decryptedDataBufLen);
            System.arraycopy(b, 0, this.decryptedDataBuf, this.decryptedDataBufLen, len);
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = newLen;
        } else {
            System.arraycopy(b, 0, this.decryptedDataBuf, this.decryptedDataBufPos + this.decryptedDataBufLen, len);
            this.decryptedDataBufLen = newLen;
        }
    }

    private int copyOutData(byte[] b, int off, int len) {
        if (this.decryptedDataBufLen == 0) {
            return -1;
        }
        int dataLen = len > this.decryptedDataBufLen ? this.decryptedDataBufLen : len;
        System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, b, off, dataLen);
        this.decryptedDataBufPos += dataLen;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= dataLen;
        return dataLen;
    }

    public void setClientLocale(String loc) {
        this.ClientLocale = loc;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

