/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.crypto.digest;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.crypto.EncodingUtils;
import org.talend.daikon.crypto.KeySource;
import org.talend.daikon.crypto.KeySources;
import org.talend.daikon.crypto.digest.DigestSource;

public class Digester {
    public static final char NO_DELIMITER = '\u0000';
    private final DigestSource digestSource;
    private final KeySource keySource;
    private final char delimiter;
    private static final int[] FORBIDDEN_DELIMITERS = new int[]{47, 61};

    public Digester(DigestSource digestSource) {
        this(KeySources.random(16), '-', digestSource);
    }

    public Digester(KeySource keySource, DigestSource digestSource) {
        this(keySource, '-', digestSource);
    }

    public Digester(KeySource keySource, char delimiter, DigestSource digestSource) {
        if (Character.isLetterOrDigit(delimiter) || Arrays.stream(FORBIDDEN_DELIMITERS).anyMatch(c -> c == delimiter)) {
            String forbiddenDelimiters = Arrays.stream(FORBIDDEN_DELIMITERS).mapToObj(i -> String.valueOf((char)i)).collect(Collectors.joining());
            throw new IllegalArgumentException("Delimiter cannot be number, letter or '" + forbiddenDelimiters + "'.");
        }
        this.keySource = keySource;
        this.delimiter = delimiter;
        this.digestSource = digestSource;
    }

    private static byte[] decode(byte[] bytes) {
        return EncodingUtils.BASE64_DECODER.apply(bytes);
    }

    private static String encode(byte[] salt) {
        return EncodingUtils.BASE64_ENCODER.apply(salt);
    }

    private String saltValue(String value, byte[] salt) {
        if (this.delimiter == '\u0000') {
            return this.digestSource.digest(value, salt);
        }
        return Digester.encode(salt) + this.delimiter + this.digestSource.digest(value, salt);
    }

    public String digest(String value) throws Exception {
        return this.saltValue(value, this.keySource.getKey());
    }

    public boolean validate(String value, String digest) {
        if (this.delimiter == '\u0000') {
            return this.digestSource.digest(value, new byte[0]).equals(digest);
        }
        try {
            if (digest.indexOf(this.delimiter) < 0) {
                throw new IllegalArgumentException("No delimiter found in digest.");
            }
            String saltBase64 = StringUtils.substringBefore((String)digest, (String)String.valueOf(this.delimiter));
            byte[] salt = Digester.decode(saltBase64.getBytes("UTF-8"));
            return (saltBase64 + this.delimiter + this.digestSource.digest(value, salt)).equals(digest);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

