/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.wizard;

import org.talend.components.api.properties.ComponentPropertiesImpl;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.JdbcRuntimeInfo;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSink;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;
import org.talend.daikon.properties.service.Repository;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.runtime.RuntimeUtil;
import org.talend.daikon.sandbox.SandboxedInstance;

public class JDBCConnectionWizardProperties
extends ComponentPropertiesImpl
implements RuntimeSettingProvider {
    public Property<String> name = PropertyFactory.newString((String)"name").setRequired();
    private String repositoryLocation;
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection").useInWizard();
    public Property<String> mappingFile = PropertyFactory.newProperty((String)"mappingFile");
    public transient PresentationItem testConnection = new PresentationItem("testConnection", "Test connection");

    public JDBCConnectionWizardProperties(String name) {
        super(name);
    }

    public void setupProperties() {
        super.setupProperties();
    }

    public void setupLayout() {
        super.setupLayout();
        Form wizardForm = CommonUtils.addForm((Properties)this, "Main");
        wizardForm.addRow(this.name);
        wizardForm.addRow((NamedThing)this.connection.getForm("Main"));
        wizardForm.addRow(Widget.widget(this.mappingFile).setWidgetType("widget.type.mappingType"));
        wizardForm.addRow(Widget.widget((NamedThing)this.testConnection).setLongRunning(true).setWidgetType("widget.type.button"));
    }

    public ValidationResult validateTestConnection() {
        JdbcRuntimeInfo jdbcRuntimeInfo = new JdbcRuntimeInfo(this, "org.talend.components.jdbc.runtime.JDBCSourceOrSink");
        try (SandboxedInstance sandboxI = RuntimeUtil.createRuntimeClassWithCurrentJVMProperties((RuntimeInfo)jdbcRuntimeInfo, (ClassLoader)((Object)((Object)this.connection)).getClass().getClassLoader());){
            JdbcRuntimeSourceOrSink sourceOrSink = (JdbcRuntimeSourceOrSink)sandboxI.getInstance();
            sourceOrSink.initialize(null, (Properties)this);
            ValidationResult vr = sourceOrSink.validate(null);
            if (vr.getStatus() == ValidationResult.Result.OK) {
                vr = new ValidationResult(ValidationResult.Result.OK, "Connection successful");
                this.getForm("Main").setAllowFinish(true);
            } else {
                this.getForm("Main").setAllowFinish(false);
            }
            ValidationResult validationResult = vr;
            return validationResult;
        }
    }

    public JDBCConnectionWizardProperties setRepositoryLocation(String location) {
        this.repositoryLocation = location;
        return this;
    }

    public ValidationResult afterFormFinishMain(Repository<Properties> repo) throws Exception {
        JdbcRuntimeInfo jdbcRuntimeInfo = new JdbcRuntimeInfo(this, "org.talend.components.jdbc.runtime.JDBCSourceOrSink");
        try (SandboxedInstance sandboxI = RuntimeUtil.createRuntimeClassWithCurrentJVMProperties((RuntimeInfo)jdbcRuntimeInfo, (ClassLoader)((Object)((Object)this.connection)).getClass().getClassLoader());){
            JdbcRuntimeSourceOrSink sourceOrSink = (JdbcRuntimeSourceOrSink)sandboxI.getInstance();
            sourceOrSink.initialize(null, (Properties)this);
            ValidationResult vr = sourceOrSink.validate(null);
            if (vr.getStatus() != ValidationResult.Result.OK) {
                ValidationResult validationResult = vr;
                return validationResult;
            }
            repo.storeProperties((Properties)this, (String)this.name.getValue(), this.repositoryLocation, null);
            ValidationResult validationResult = ValidationResult.OK;
            return validationResult;
        }
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setCommonConnectionInfo(setting, this.connection);
        return setting;
    }
}

