/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.tjdbcrow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.components.api.component.PropertyPathConnector;
import org.talend.components.api.properties.ComponentReferenceProperties;
import org.talend.components.common.FixedConnectorsComponentProperties;
import org.talend.components.common.SchemaProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.module.JDBCTableSelectionModule;
import org.talend.components.jdbc.module.PreparedStatementTable;
import org.talend.components.jdbc.query.QueryUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.tjdbcconnection.TJDBCConnectionProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class TJDBCRowProperties
extends FixedConnectorsComponentProperties
implements RuntimeSettingProvider {
    public ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent = new ComponentReferenceProperties("referencedComponent", "tJDBCConnection");
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection");
    public transient PropertyPathConnector MAIN_CONNECTOR = new PropertyPathConnector("MAIN", "main");
    public transient PropertyPathConnector FLOW_CONNECTOR = new PropertyPathConnector("MAIN", "schemaFlow");
    public transient PropertyPathConnector REJECT_CONNECTOR = new PropertyPathConnector("REJECT", "schemaReject");
    public SchemaProperties main = new SchemaProperties("main"){

        public void afterSchema() {
            TJDBCRowProperties.this.updateOutputSchemas();
            TJDBCRowProperties.this.updateUseColumn();
        }
    };
    public SchemaProperties schemaFlow = new SchemaProperties("schemaFlow");
    public SchemaProperties schemaReject = new SchemaProperties("schemaReject");
    public JDBCTableSelectionModule tableSelection = new JDBCTableSelectionModule("tableSelection");
    public Property<String> sql = PropertyFactory.newString((String)"sql").setRequired(true);
    public final transient PresentationItem guessQueryFromSchema = new PresentationItem("guessQueryFromSchema", "Guess Query");
    public Property<Boolean> useDataSource = PropertyFactory.newBoolean((String)"useDataSource").setRequired();
    public Property<String> dataSource = PropertyFactory.newProperty((String)"dataSource").setRequired();
    public Property<Boolean> dieOnError = PropertyFactory.newBoolean((String)"dieOnError").setRequired();
    public Property<Boolean> propagateQueryResultSet = PropertyFactory.newBoolean((String)"propagateQueryResultSet").setRequired();
    public Property<String> useColumn = PropertyFactory.newString((String)"useColumn");
    public Property<Boolean> usePreparedStatement = PropertyFactory.newBoolean((String)"usePreparedStatement").setRequired();
    public PreparedStatementTable preparedStatementTable = new PreparedStatementTable("preparedStatementTable");
    public Property<Integer> commitEvery = PropertyFactory.newInteger((String)"commitEvery").setRequired();

    public TJDBCRowProperties(String name) {
        super(name);
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        Widget compListWidget = Widget.widget(this.referencedComponent).setWidgetType("widget.type.component.reference");
        mainForm.addRow(compListWidget);
        mainForm.addRow((NamedThing)this.connection.getForm("Main"));
        mainForm.addRow((NamedThing)this.main.getForm("Reference"));
        mainForm.addRow((NamedThing)this.tableSelection.getForm("Reference"));
        mainForm.addRow(Widget.widget((NamedThing)this.guessQueryFromSchema).setWidgetType("widget.type.button"));
        mainForm.addRow(Widget.widget(this.sql).setWidgetType("widget.type.memoSql"));
        mainForm.addRow(this.useDataSource);
        mainForm.addRow(this.dataSource);
        mainForm.addRow(this.dieOnError);
        Form advancedForm = CommonUtils.addForm((Properties)this, "Advanced");
        advancedForm.addRow(this.propagateQueryResultSet);
        advancedForm.addColumn(Widget.widget(this.useColumn).setWidgetType("widget.type.enumeration"));
        advancedForm.addRow(this.usePreparedStatement);
        advancedForm.addRow(Widget.widget((NamedThing)this.preparedStatementTable).setWidgetType("widget.type.table"));
        advancedForm.addRow(this.commitEvery);
    }

    public void setupProperties() {
        super.setupProperties();
        this.commitEvery.setValue((Object)10000);
        this.sql.setValue((Object)"select id, name from employee");
        this.tableSelection.setConnection(this);
        this.connection.setNotRequired();
        this.sql.setTaggedValue("LINE_SEPARATOR_REPLACED_TO", (Object)" ");
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        boolean useOtherConnection = CommonUtils.useExistedConnection(this.referencedComponent);
        if (form.getName().equals("Main")) {
            form.getChildForm(this.connection.getName()).setHidden(useOtherConnection);
            if (useOtherConnection) {
                form.getWidget(this.useDataSource.getName()).setHidden(true);
                form.getWidget(this.dataSource.getName()).setHidden(true);
            } else {
                form.getWidget(this.useDataSource.getName()).setHidden(false);
                form.getWidget(this.dataSource.getName()).setHidden((Boolean)this.useDataSource.getValue() == false);
            }
        }
        if (form.getName().equals("Advanced")) {
            form.getWidget(this.commitEvery.getName()).setHidden(useOtherConnection);
            form.getWidget(this.useColumn.getName()).setHidden((Boolean)this.propagateQueryResultSet.getValue() == false);
            form.getWidget(this.preparedStatementTable.getName()).setHidden((Boolean)this.usePreparedStatement.getValue() == false);
        }
    }

    public void afterReferencedComponent() {
        this.refreshLayout(this.getForm("Main"));
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterUseDataSource() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterPropagateQueryResultSet() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterUsePreparedStatement() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void updateOutputSchemas() {
        Schema inputSchema = (Schema)this.main.schema.getValue();
        this.schemaFlow.schema.setValue((Object)inputSchema);
        ArrayList<Schema.Field> additionalRejectFields = new ArrayList<Schema.Field>();
        Schema.Field field = new Schema.Field("errorCode", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        field.addProp("talend.isLocked", "false");
        field.addProp("talend.field.generated", "true");
        field.addProp("talend.field.length", "255");
        additionalRejectFields.add(field);
        field = new Schema.Field("errorMessage", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        field.addProp("talend.isLocked", "false");
        field.addProp("talend.field.generated", "true");
        field.addProp("talend.field.length", "255");
        additionalRejectFields.add(field);
        Schema rejectSchema = CommonUtils.newSchema(inputSchema, "rejectOutput", additionalRejectFields);
        this.schemaReject.schema.setValue((Object)rejectSchema);
    }

    protected Set<PropertyPathConnector> getAllSchemaPropertiesConnectors(boolean isOutputConnection) {
        HashSet<PropertyPathConnector> connectors = new HashSet<PropertyPathConnector>();
        if (isOutputConnection) {
            connectors.add(this.FLOW_CONNECTOR);
            connectors.add(this.REJECT_CONNECTOR);
        } else {
            connectors.add(this.MAIN_CONNECTOR);
        }
        return connectors;
    }

    public ValidationResult afterGuessQueryFromSchema() {
        String tablenameDisplayed = this.tableSelection.tablename.getStoredValue() == null ? null : this.tableSelection.tablename.getStoredValue().toString();
        Schema schema = (Schema)this.main.schema.getValue();
        if (tablenameDisplayed == null || tablenameDisplayed.isEmpty()) {
            return new ValidationResult(ValidationResult.Result.ERROR, "Please set the table name before it");
        }
        if (schema == null || schema.getFields().isEmpty()) {
            return new ValidationResult(ValidationResult.Result.ERROR, "Please set the schema before it");
        }
        String query = QueryUtils.generateNewQuery("General JDBC", null, null, tablenameDisplayed, this.getRuntimeSetting());
        this.sql.setValue((Object)query);
        this.refreshLayout(this.getForm("Main"));
        return ValidationResult.OK;
    }

    public void beforeUseColumn() {
        this.updateUseColumn();
    }

    private void updateUseColumn() {
        CommonUtils.updatePossibleValues(this.useColumn, this.getFieldNames((Property<Schema>)this.main.schema));
    }

    private List<String> getFieldNames(Property<Schema> schema) {
        Schema s = (Schema)schema.getValue();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Schema.Field f : s.getFields()) {
            fieldNames.add(f.name());
        }
        return fieldNames;
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setReferenceInfoAndConnectionInfo(setting, this.referencedComponent, this.connection);
        setting.setTablename((String)this.tableSelection.tablename.getValue());
        setting.setSql((String)this.sql.getValue());
        setting.setDieOnError((Boolean)this.dieOnError.getValue());
        setting.setCommitEvery((Integer)this.commitEvery.getValue());
        setting.setPropagateQueryResultSet((Boolean)this.propagateQueryResultSet.getValue());
        setting.setUseColumn((String)this.useColumn.getValue());
        setting.setUsePreparedStatement((Boolean)this.usePreparedStatement.getValue());
        setting.setIndexs(this.preparedStatementTable.indexs.getValue());
        setting.setTypes(this.preparedStatementTable.types.getValue());
        setting.setValues(this.preparedStatementTable.values.getValue());
        setting.setUseDataSource((Boolean)this.useDataSource.getValue());
        setting.setDataSource((String)this.dataSource.getValue());
        setting.setSchema((Schema)this.main.schema.getValue());
        return setting;
    }
}

