/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.tjdbcinput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.ISchemaListener;
import org.talend.components.api.component.PropertyPathConnector;
import org.talend.components.api.properties.ComponentReferenceProperties;
import org.talend.components.common.FixedConnectorsComponentProperties;
import org.talend.components.common.SchemaProperties;
import org.talend.components.common.TrimFieldsTable;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.JdbcRuntimeInfo;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.DBTypes;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.module.JDBCTableSelectionModule;
import org.talend.components.jdbc.module.PreparedStatementTable;
import org.talend.components.jdbc.query.QueryUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSink;
import org.talend.components.jdbc.tjdbcconnection.TJDBCConnectionProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;
import org.talend.daikon.properties.runtime.RuntimeContext;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.runtime.RuntimeUtil;
import org.talend.daikon.sandbox.SandboxedInstance;

public class TJDBCInputProperties
extends FixedConnectorsComponentProperties
implements RuntimeSettingProvider {
    static final Logger LOG = LoggerFactory.getLogger(TJDBCInputProperties.class);
    public ComponentReferenceProperties<TJDBCConnectionProperties> referencedComponent = new ComponentReferenceProperties("referencedComponent", "tJDBCConnection");
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection");
    public final transient PropertyPathConnector mainConnector = new PropertyPathConnector("MAIN", "main");
    public ISchemaListener schemaListener;
    public SchemaProperties main = new SchemaProperties("main"){

        public void afterSchema() {
            if (TJDBCInputProperties.this.schemaListener != null) {
                TJDBCInputProperties.this.schemaListener.afterSchema();
            }
        }
    };
    public JDBCTableSelectionModule tableSelection = new JDBCTableSelectionModule("tableSelection");
    public Property<String> sql = PropertyFactory.newString((String)"sql").setRequired(true);
    public final transient PresentationItem fetchSchemaFromQuery = new PresentationItem("fetchSchemaFromQuery", "Guess schema");
    public final transient PresentationItem guessQueryFromSchema = new PresentationItem("guessQueryFromSchema", "Guess Query");
    public Property<Boolean> useDataSource = PropertyFactory.newBoolean((String)"useDataSource").setRequired();
    public Property<String> dataSource = PropertyFactory.newProperty((String)"dataSource").setRequired();
    public Property<Boolean> useCursor = PropertyFactory.newBoolean((String)"useCursor").setRequired();
    public Property<Integer> cursor = PropertyFactory.newInteger((String)"cursor").setRequired();
    public Property<Boolean> trimStringOrCharColumns = PropertyFactory.newBoolean((String)"trimStringOrCharColumns").setRequired();
    public TrimFieldsTable trimTable = new TrimFieldsTable("trimTable");
    public Property<Boolean> enableDBMapping = PropertyFactory.newBoolean((String)"enableDBMapping").setRequired();
    public Property<DBTypes> dbMapping = PropertyFactory.newEnum((String)"dbMapping", DBTypes.class);
    public Property<Boolean> usePreparedStatement = PropertyFactory.newBoolean((String)"usePreparedStatement").setRequired();
    public PreparedStatementTable preparedStatementTable = new PreparedStatementTable("preparedStatementTable");

    public TJDBCInputProperties(String name) {
        super(name);
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        Widget compListWidget = Widget.widget(this.referencedComponent).setWidgetType("widget.type.component.reference");
        mainForm.addRow(compListWidget);
        mainForm.addRow((NamedThing)this.connection.getForm("Main"));
        mainForm.addRow((NamedThing)this.main.getForm("Reference"));
        mainForm.addRow((NamedThing)this.tableSelection.getForm("Reference"));
        mainForm.addRow(Widget.widget((NamedThing)this.guessQueryFromSchema).setWidgetType("widget.type.button"));
        mainForm.addColumn(Widget.widget((NamedThing)this.fetchSchemaFromQuery).setWidgetType("widget.type.button"));
        mainForm.addRow(Widget.widget(this.sql).setWidgetType("widget.type.memoSql"));
        mainForm.addRow(this.useDataSource);
        mainForm.addRow(this.dataSource);
        Form advancedForm = CommonUtils.addForm((Properties)this, "Advanced");
        advancedForm.addRow(this.useCursor);
        advancedForm.addRow(this.cursor);
        advancedForm.addRow(this.trimStringOrCharColumns);
        advancedForm.addRow(Widget.widget((NamedThing)this.trimTable).setWidgetType("widget.type.table"));
        advancedForm.addRow(this.enableDBMapping);
        advancedForm.addRow(Widget.widget(this.dbMapping).setWidgetType("widget.type.enumeration"));
        advancedForm.addRow(this.usePreparedStatement);
        advancedForm.addRow(Widget.widget((NamedThing)this.preparedStatementTable).setWidgetType("widget.type.table"));
    }

    public void setupProperties() {
        super.setupProperties();
        this.sql.setValue((Object)"select id, name from employee");
        this.cursor.setValue((Object)1000);
        this.tableSelection.setConnection(this);
        this.dbMapping.setValue((Object)DBTypes.MYSQL);
        this.schemaListener = new ISchemaListener(){

            public void afterSchema() {
                TJDBCInputProperties.this.updateTrimTable();
            }
        };
        this.connection.setNotRequired();
        this.sql.setTaggedValue("LINE_SEPARATOR_REPLACED_TO", (Object)" ");
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        boolean useOtherConnection = CommonUtils.useExistedConnection(this.referencedComponent);
        if (form.getName().equals("Main")) {
            form.getChildForm(this.connection.getName()).setHidden(useOtherConnection);
            if (useOtherConnection) {
                form.getWidget(this.useDataSource.getName()).setHidden(true);
                form.getWidget(this.dataSource.getName()).setHidden(true);
            } else {
                form.getWidget(this.useDataSource.getName()).setHidden(false);
                form.getWidget(this.dataSource.getName()).setHidden((Boolean)this.useDataSource.getValue() == false);
            }
        }
        if (form.getName().equals("Advanced")) {
            form.getWidget(this.cursor.getName()).setHidden((Boolean)this.useCursor.getValue() == false);
            form.getWidget(this.trimTable.getName()).setHidden(((Boolean)this.trimStringOrCharColumns.getValue()).booleanValue());
            form.getWidget(this.dbMapping.getName()).setVisible(((Boolean)this.enableDBMapping.getValue()).booleanValue());
            form.getWidget(this.preparedStatementTable.getName()).setHidden((Boolean)this.usePreparedStatement.getValue() == false);
            this.updateTrimTable();
        }
    }

    private void updateTrimTable() {
        Schema schema = (Schema)this.main.schema.getValue();
        if (schema == null) {
            return;
        }
        boolean dynamic = AvroUtils.isIncludeAllFields((Schema)schema);
        int dynamicIndex = -1;
        String dynamicFieldName = schema.getProp("di.dynamic.column.name");
        if (dynamic) {
            dynamicIndex = Integer.valueOf(schema.getProp("di.dynamic.column.position"));
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        int i = 0;
        List fields = schema.getFields();
        for (Schema.Field f : fields) {
            if (i == dynamicIndex) {
                fieldNames.add(dynamicFieldName);
            }
            fieldNames.add(f.name());
            ++i;
        }
        if (dynamicIndex == i) {
            fieldNames.add(dynamicFieldName);
        }
        this.trimTable.columnName.setValue(fieldNames);
    }

    public void afterReferencedComponent() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterUseDataSource() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterUseCursor() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterTrimStringOrCharColumns() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterEnableDBMapping() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void afterUsePreparedStatement() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void beforePreparedStatementTable() {
        this.preparedStatementTable.types.setPossibleValues((Object[])PreparedStatementTable.Type.values());
    }

    protected Set<PropertyPathConnector> getAllSchemaPropertiesConnectors(boolean isOutputConnection) {
        if (isOutputConnection) {
            return Collections.singleton(this.mainConnector);
        }
        return Collections.emptySet();
    }

    public ValidationResult afterFetchSchemaFromQuery(RuntimeContext runtimeContext) {
        Object mappingFileLocation = runtimeContext.getData("MAPPING_LOCATION");
        if (mappingFileLocation == null) {
            return new ValidationResult(ValidationResult.Result.ERROR, "can't find the mapping files directory");
        }
        JdbcRuntimeInfo jdbcRuntimeInfo = new JdbcRuntimeInfo(this, "org.talend.components.jdbc.runtime.JDBCSource");
        try (SandboxedInstance sandboxI = RuntimeUtil.createRuntimeClassWithCurrentJVMProperties((RuntimeInfo)jdbcRuntimeInfo, (ClassLoader)((Object)((Object)this.connection)).getClass().getClassLoader());){
            JdbcRuntimeSourceOrSink ss = (JdbcRuntimeSourceOrSink)sandboxI.getInstance();
            ss.initialize(null, (Properties)this);
            try {
                ss.setDBTypeMapping(CommonUtils.getMapping((String)mappingFileLocation, this.getRuntimeSetting(), null, (DBTypes)((Object)this.dbMapping.getValue())));
                Schema schema = ss.getSchemaFromQuery(null, (String)this.sql.getValue());
                this.main.schema.setValue((Object)schema);
            }
            catch (Exception e) {
                LOG.error("failed to retrieve the schema :", (Throwable)e);
                ValidationResult validationResult = new ValidationResult(ValidationResult.Result.ERROR, CommonUtils.getClearExceptionInfo(e));
                if (sandboxI != null) {
                    if (var5_5 != null) {
                        try {
                            sandboxI.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        sandboxI.close();
                    }
                }
                return validationResult;
            }
        }
        return ValidationResult.OK;
    }

    public ValidationResult afterFetchSchemaFromQuery() {
        return ValidationResult.OK;
    }

    public ValidationResult afterGuessQueryFromSchema() {
        String tablenameDisplayed = this.tableSelection.tablename.getStoredValue() == null ? null : this.tableSelection.tablename.getStoredValue().toString();
        Schema schema = (Schema)this.main.schema.getValue();
        if (tablenameDisplayed == null || tablenameDisplayed.isEmpty()) {
            return new ValidationResult(ValidationResult.Result.ERROR, "Please set the table name before it");
        }
        if (schema == null || schema.getFields().isEmpty()) {
            return new ValidationResult(ValidationResult.Result.ERROR, "Please set the schema before it");
        }
        String query = QueryUtils.generateNewQuery("General JDBC", null, null, tablenameDisplayed, this.getRuntimeSetting());
        this.sql.setValue((Object)query);
        this.refreshLayout(this.getForm("Main"));
        return ValidationResult.OK;
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setReferenceInfoAndConnectionInfo(setting, this.referencedComponent, this.connection);
        setting.setTablename((String)this.tableSelection.tablename.getValue());
        setting.setSql((String)this.sql.getValue());
        setting.setUseDataSource((Boolean)this.useDataSource.getValue());
        setting.setDataSource((String)this.dataSource.getValue());
        setting.setUseCursor((Boolean)this.useCursor.getValue());
        setting.setCursor((Integer)this.cursor.getValue());
        setting.setTrimStringOrCharColumns((Boolean)this.trimStringOrCharColumns.getValue());
        setting.setTrims(this.trimTable.trim.getValue());
        setting.setTrimColumns(this.trimTable.columnName.getValue());
        setting.setEnableDBMapping((Boolean)this.enableDBMapping.getValue());
        setting.setDbMapping((DBTypes)((Object)this.dbMapping.getValue()));
        setting.setSchema((Schema)this.main.schema.getValue());
        setting.setUsePreparedStatement((Boolean)this.usePreparedStatement.getValue());
        setting.setIndexs(this.preparedStatementTable.indexs.getValue());
        setting.setTypes(this.preparedStatementTable.types.getValue());
        setting.setValues(this.preparedStatementTable.values.getValue());
        return setting;
    }
}

