/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.tjdbcconnection;

import org.talend.components.api.properties.ComponentPropertiesImpl;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.JDBCConnectionModule;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class TJDBCConnectionProperties
extends ComponentPropertiesImpl
implements RuntimeSettingProvider {
    public JDBCConnectionModule connection = new JDBCConnectionModule("connection");
    public Property<Boolean> shareConnection = PropertyFactory.newBoolean((String)"shareConnection");
    public Property<String> sharedConnectionName = PropertyFactory.newString((String)"sharedConnectionName");
    public Property<Boolean> useDataSource = PropertyFactory.newBoolean((String)"useDataSource").setRequired();
    public Property<String> dataSource = PropertyFactory.newProperty((String)"dataSource").setRequired();
    public Property<Boolean> useAutoCommit = PropertyFactory.newBoolean((String)"useAutoCommit");
    public Property<Boolean> autocommit = PropertyFactory.newBoolean((String)"autocommit");

    public TJDBCConnectionProperties(String name) {
        super(name);
    }

    public void setupProperties() {
        super.setupProperties();
        this.useAutoCommit.setValue((Object)true);
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        mainForm.addRow((NamedThing)this.connection.getForm("Main"));
        mainForm.addRow(this.shareConnection);
        mainForm.addRow(this.sharedConnectionName);
        mainForm.addRow(this.useDataSource);
        mainForm.addRow(this.dataSource);
        Form advancedForm = CommonUtils.addForm((Properties)this, "Advanced");
        advancedForm.addRow(this.useAutoCommit);
        advancedForm.addColumn(this.autocommit);
    }

    public void afterShareConnection() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterUseDataSource() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void afterUseAutoCommit() {
        this.refreshLayout(this.getForm("Advanced"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if ("Advanced".equals(form.getName())) {
            form.getWidget(this.autocommit.getName()).setHidden((Boolean)this.useAutoCommit.getValue() == false);
        }
        if ("Main".equals(form.getName())) {
            if (((Boolean)this.shareConnection.getValue()).booleanValue()) {
                form.getWidget(this.sharedConnectionName.getName()).setHidden(false);
                form.getWidget(this.useDataSource.getName()).setHidden(true);
                form.getWidget(this.dataSource.getName()).setHidden(true);
            } else {
                form.getWidget(this.sharedConnectionName.getName()).setHidden(true);
                form.getWidget(this.useDataSource.getName()).setHidden(false);
                form.getWidget(this.dataSource.getName()).setHidden((Boolean)this.useDataSource.getValue() == false);
            }
            if (((Boolean)this.useDataSource.getValue()).booleanValue()) {
                form.getWidget(this.dataSource.getName()).setHidden(false);
                form.getWidget(this.shareConnection.getName()).setHidden(true);
                form.getWidget(this.sharedConnectionName.getName()).setHidden(true);
            } else {
                form.getWidget(this.dataSource.getName()).setHidden(true);
                form.getWidget(this.shareConnection.getName()).setHidden(false);
                form.getWidget(this.sharedConnectionName.getName()).setHidden((Boolean)this.shareConnection.getValue() == false);
            }
        }
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        CommonUtils.setCommonConnectionInfo(setting, this.connection);
        setting.setShareConnection((Boolean)this.shareConnection.getValue());
        setting.setSharedConnectionName((String)this.sharedConnectionName.getValue());
        setting.setUseDataSource((Boolean)this.useDataSource.getValue());
        setting.setDataSource((String)this.dataSource.getValue());
        setting.setUseAutoCommit((Boolean)this.useAutoCommit.getValue());
        setting.setAutocommit((Boolean)this.autocommit.getValue());
        return setting;
    }
}

