/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.setting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.components.jdbc.module.AdditionalColumnsTable;
import org.talend.components.jdbc.runtime.setting.AllSetting;

public class JDBCSQLBuilder {
    private JDBCSQLBuilder() {
    }

    public static JDBCSQLBuilder getInstance() {
        return new JDBCSQLBuilder();
    }

    protected String getProtectedChar() {
        return "";
    }

    public String generateSQL4SelectTable(String tablename, Schema schema) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        List fields = schema.getFields();
        boolean firstOne = true;
        for (Schema.Field field : fields) {
            if (firstOne) {
                firstOne = false;
            } else {
                sql.append(", ");
            }
            String dbColumnName = field.getProp("talend.field.dbColumnName");
            sql.append(tablename).append(".").append(dbColumnName);
        }
        sql.append(" FROM ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar());
        return sql.toString();
    }

    public String generateSQL4DeleteTable(String tablename) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar());
        return sql.toString();
    }

    public String generateSQL4Insert(String tablename, List<Column> columnList) {
        ArrayList<String> dbColumnNames = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        List<Column> all = this.getAllColumns(columnList);
        for (Column column : all) {
            if (!column.insertable) continue;
            dbColumnNames.add(column.dbColumnName);
            expressions.add(column.sqlStmt);
        }
        return this.generateSQL4Insert(tablename, dbColumnNames, expressions);
    }

    public List<Column> createColumnList(AllSetting setting, Schema schema) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        ArrayList<Column> columnList = new ArrayList<Column>();
        List fields = schema.getFields();
        for (Schema.Field field : fields) {
            Column column = new Column();
            column.columnLabel = field.name();
            column.dbColumnName = field.getProp("talend.field.dbColumnName");
            boolean isKey = Boolean.valueOf(field.getProp("talend.field.isKey"));
            if (isKey) {
                column.updateKey = true;
                column.deletionKey = true;
                column.updatable = false;
            } else {
                column.updateKey = false;
                column.deletionKey = false;
                column.updatable = true;
            }
            columnMap.put(field.name(), column);
            columnList.add(column);
        }
        boolean enableFieldOptions = setting.getEnableFieldOptions();
        if (enableFieldOptions) {
            List<String> schemaColumns4FieldOption = setting.getSchemaColumns4FieldOption();
            List<Boolean> updateKey = setting.getUpdateKey4FieldOption();
            List<Boolean> deletionKey = setting.getDeletionKey4FieldOption();
            List<Boolean> updatable = setting.getUpdatable4FieldOption();
            List<Boolean> insertable = setting.getInsertable4FieldOption();
            int i = 0;
            for (String columnName : schemaColumns4FieldOption) {
                Column column = (Column)columnMap.get(columnName);
                column.updateKey = updateKey.get(i);
                column.deletionKey = deletionKey.get(i);
                column.updatable = updatable.get(i);
                column.insertable = insertable.get(i);
                ++i;
            }
        }
        List<String> newDBColumnNames = setting.getNewDBColumnNames4AdditionalParameters();
        List<String> sqlExpressions = setting.getSqlExpressions4AdditionalParameters();
        List<String> positions = setting.getPositions4AdditionalParameters();
        List<String> referenceColumns = setting.getReferenceColumns4AdditionalParameters();
        int i = 0;
        for (String referenceColumn : referenceColumns) {
            Column newColumn;
            int j = 0;
            Column currentColumn = null;
            for (Column column : columnList) {
                if (column.columnLabel.equals(referenceColumn)) {
                    currentColumn = column;
                    break;
                }
                ++j;
            }
            String newDBColumnName = newDBColumnNames.get(i);
            String sqlExpression = sqlExpressions.get(i);
            AdditionalColumnsTable.Position position = AdditionalColumnsTable.Position.valueOf(positions.get(i));
            if (position == AdditionalColumnsTable.Position.AFTER) {
                newColumn = new Column();
                newColumn.columnLabel = newDBColumnName;
                newColumn.dbColumnName = newDBColumnName;
                newColumn.sqlStmt = sqlExpression;
                newColumn.addCol = true;
                columnList.add(j + 1, newColumn);
            } else if (position == AdditionalColumnsTable.Position.BEFORE) {
                newColumn = new Column();
                newColumn.columnLabel = newDBColumnName;
                newColumn.dbColumnName = newDBColumnName;
                newColumn.sqlStmt = sqlExpression;
                newColumn.addCol = true;
                columnList.add(j, newColumn);
            } else if (position == AdditionalColumnsTable.Position.REPLACE) {
                Column replacementColumn = new Column();
                replacementColumn.columnLabel = newDBColumnName;
                replacementColumn.dbColumnName = newDBColumnName;
                replacementColumn.sqlStmt = sqlExpression;
                Column replacedColumn = currentColumn;
                replacementColumn.isKey = replacedColumn.isKey;
                replacementColumn.updateKey = replacedColumn.updateKey;
                replacementColumn.deletionKey = replacedColumn.deletionKey;
                replacementColumn.insertable = replacedColumn.insertable;
                replacementColumn.updatable = replacedColumn.updatable;
                replacedColumn.replace(replacementColumn);
            }
            ++i;
        }
        return columnList;
    }

    public String generateSQL4Insert(String tablename, Schema schema) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar()).append(" ");
        sb.append("(");
        List fields = schema.getFields();
        boolean firstOne = true;
        for (Schema.Field field : fields) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(",");
            }
            String dbColumnName = field.getProp("talend.field.dbColumnName");
            sb.append(dbColumnName);
        }
        sb.append(")");
        sb.append(" VALUES ");
        sb.append("(");
        firstOne = true;
        for (Schema.Field field : fields) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    private String generateSQL4Insert(String tablename, List<String> insertableDBColumns, List<String> expressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar()).append(" ");
        sb.append("(");
        boolean firstOne = true;
        for (String dbColumnName : insertableDBColumns) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(",");
            }
            sb.append(dbColumnName);
        }
        sb.append(")");
        sb.append(" VALUES ");
        sb.append("(");
        firstOne = true;
        for (String expression : expressions) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(",");
            }
            sb.append(expression);
        }
        sb.append(")");
        return sb.toString();
    }

    public String generateSQL4Delete(String tablename, List<Column> columnList) {
        ArrayList<String> deleteKeys = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        List<Column> all = this.getAllColumns(columnList);
        for (Column column : all) {
            if (!column.deletionKey) continue;
            deleteKeys.add(column.dbColumnName);
            expressions.add(column.sqlStmt);
        }
        return this.generateSQL4Delete(tablename, deleteKeys, expressions);
    }

    private String generateSQL4Delete(String tablename, List<String> deleteKeys, List<String> expressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar()).append(" WHERE ");
        int i = 0;
        boolean firstOne = true;
        for (String dbColumnName : deleteKeys) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(" AND ");
            }
            sb.append(this.getProtectedChar()).append(dbColumnName).append(this.getProtectedChar()).append(" = ").append(expressions.get(i++));
        }
        return sb.toString();
    }

    private String generateSQL4Update(String tablename, List<String> updateValues, List<String> updateKeys, List<String> updateValueExpressions, List<String> updateKeyExpressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar()).append(" SET ");
        int i = 0;
        boolean firstOne = true;
        for (String dbColumnName : updateValues) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(",");
            }
            sb.append(this.getProtectedChar()).append(dbColumnName).append(this.getProtectedChar()).append(" = ").append(updateValueExpressions.get(i++));
        }
        i = 0;
        sb.append(" WHERE ");
        firstOne = true;
        for (String dbColumnName : updateKeys) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(" AND ");
            }
            sb.append(this.getProtectedChar()).append(dbColumnName).append(this.getProtectedChar()).append(" = ").append(updateKeyExpressions.get(i++));
        }
        return sb.toString();
    }

    public String generateSQL4Update(String tablename, List<Column> columnList) {
        ArrayList<String> updateValues = new ArrayList<String>();
        ArrayList<String> updateValueExpressions = new ArrayList<String>();
        ArrayList<String> updateKeys = new ArrayList<String>();
        ArrayList<String> updateKeyExpressions = new ArrayList<String>();
        List<Column> all = this.getAllColumns(columnList);
        for (Column column : all) {
            if (column.updatable) {
                updateValues.add(column.dbColumnName);
                updateValueExpressions.add(column.sqlStmt);
            }
            if (!column.updateKey) continue;
            updateKeys.add(column.dbColumnName);
            updateKeyExpressions.add(column.sqlStmt);
        }
        return this.generateSQL4Update(tablename, updateValues, updateKeys, updateValueExpressions, updateKeyExpressions);
    }

    private String generateQuerySQL4InsertOrUpdate(String tablename, List<String> updateKeys, List<String> updateKeyExpressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(1) FROM ").append(this.getProtectedChar()).append(tablename).append(this.getProtectedChar()).append(" WHERE ");
        int i = 0;
        boolean firstOne = true;
        for (String dbColumnName : updateKeys) {
            if (firstOne) {
                firstOne = false;
            } else {
                sb.append(" AND ");
            }
            sb.append(this.getProtectedChar()).append(dbColumnName).append(this.getProtectedChar()).append(" = ").append(updateKeyExpressions.get(i++));
        }
        return sb.toString();
    }

    public String generateQuerySQL4InsertOrUpdate(String tablename, List<Column> columnList) {
        ArrayList<String> updateKeys = new ArrayList<String>();
        ArrayList<String> updateKeyExpressions = new ArrayList<String>();
        List<Column> all = this.getAllColumns(columnList);
        for (Column column : all) {
            if (!column.updateKey) continue;
            updateKeys.add(column.dbColumnName);
            updateKeyExpressions.add(column.sqlStmt);
        }
        return this.generateQuerySQL4InsertOrUpdate(tablename, updateKeys, updateKeyExpressions);
    }

    private List<Column> getAllColumns(List<Column> columnList) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : columnList) {
            if (column.replacements != null && !column.replacements.isEmpty()) {
                for (Column replacement : column.replacements) {
                    result.add(replacement);
                }
                continue;
            }
            result.add(column);
        }
        return result;
    }

    public class Column {
        public String columnLabel;
        public String dbColumnName;
        public String sqlStmt = "?";
        public boolean isKey;
        public boolean updateKey;
        public boolean deletionKey;
        public boolean updatable = true;
        public boolean insertable = true;
        public boolean addCol;
        public List<Column> replacements;

        void replace(Column replacement) {
            if (this.replacements == null) {
                this.replacements = new ArrayList<Column>();
            }
            this.replacements.add(replacement);
        }

        public boolean isReplaced() {
            return this.replacements != null && !this.replacements.isEmpty();
        }
    }
}

