/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.query.generator;

import java.util.List;
import org.apache.avro.Schema;
import org.talend.components.jdbc.query.EDatabaseTypeName;
import org.talend.components.jdbc.query.IQueryGenerator;
import org.talend.components.jdbc.query.SQLTextUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;

public class DefaultQueryGenerator
implements IQueryGenerator {
    private final EDatabaseTypeName dbType;
    private String databaseDisplayed;
    private String dbschemaDisplayed;
    private String tableDisplayed;
    private AllSetting setting;

    public DefaultQueryGenerator(EDatabaseTypeName dbType) {
        this.dbType = dbType;
    }

    @Override
    public void setParameters(String databaseDisplayed, String dbschemaDisplayed, String tableDisplayed, AllSetting setting) {
        this.databaseDisplayed = databaseDisplayed;
        this.dbschemaDisplayed = dbschemaDisplayed;
        this.tableDisplayed = tableDisplayed;
        this.setting = setting;
    }

    private String getDBName() {
        String tablename = this.removeTextFenceIfJavaLiteral(this.databaseDisplayed);
        if (!"".equals(tablename)) {
            return tablename;
        }
        return "_MyTable_";
    }

    private String getDBSchemaName() {
        String tablename = this.removeTextFenceIfJavaLiteral(this.dbschemaDisplayed);
        if (!"".equals(tablename)) {
            return tablename;
        }
        return "_MyTable_";
    }

    private String getDBTableName() {
        String tablename = this.removeTextFenceIfJavaLiteral(this.tableDisplayed);
        if (!"".equals(tablename)) {
            return tablename;
        }
        return "_MyTable_";
    }

    private String removeTextFenceIfJavaLiteral(String value) {
        if (value != null) {
            if (SQLTextUtils.containContextVariables(value)) {
                return value;
            }
            return SQLTextUtils.removeJavaTextFence(value);
        }
        return null;
    }

    protected char getSQLFieldConnector() {
        return '.';
    }

    private String getDatabaseFieldTextFence(boolean left) {
        String database_object_text_fence = SQLTextUtils.getDatabaseObjectTextFenceByDBType(this.dbType, left);
        if ("\"".equals(database_object_text_fence)) {
            return "\\\"";
        }
        return database_object_text_fence;
    }

    protected String getTableNameWithDBAndSchema(String dbName, String schema, String tableName) {
        if (tableName == null || "".equals(tableName.trim())) {
            tableName = "_MyTable_";
        }
        StringBuffer tableNameWithDBAndSchema = new StringBuffer();
        if (dbName != null && !"".equals(dbName)) {
            tableNameWithDBAndSchema.append(this.checkContextAndAddQuote(dbName));
            tableNameWithDBAndSchema.append(this.getSQLFieldConnector());
        }
        if (schema != null && !"".equals(schema)) {
            tableNameWithDBAndSchema.append(this.checkContextAndAddQuote(schema));
            tableNameWithDBAndSchema.append(this.getSQLFieldConnector());
        }
        tableNameWithDBAndSchema.append(this.checkContextAndAddQuote(tableName));
        return tableNameWithDBAndSchema.toString();
    }

    private String checkContextAndAddQuote(String field) {
        return this.checkContextAndAddQuote(field, true);
    }

    protected String checkContextAndAddQuote(String field, boolean needTextFence4SQL) {
        StringBuffer fieldSB = new StringBuffer();
        if (SQLTextUtils.containContextVariables(field)) {
            if (needTextFence4SQL && this.needTextFence4SQL()) {
                String leftDatabaseObjectTextFence = this.getDatabaseFieldTextFence(true);
                fieldSB.append(leftDatabaseObjectTextFence);
            }
            fieldSB.append(SQLTextUtils.getStringDeclare());
            fieldSB.append(SQLTextUtils.getStringConnect());
            fieldSB.append(field);
            fieldSB.append(SQLTextUtils.getStringConnect());
            fieldSB.append(SQLTextUtils.getStringDeclare());
            if (this.needTextFence4SQL()) {
                String rightDatabaseObjectTextFence = this.getDatabaseFieldTextFence(false);
                fieldSB.append(rightDatabaseObjectTextFence);
            }
        } else {
            fieldSB.append(this.addTextFenceForSQLIfNecessary(field, needTextFence4SQL));
        }
        return fieldSB.toString();
    }

    private String addTextFenceForSQLIfNecessary(String field, boolean needTextFence4SQL) {
        if (needTextFence4SQL && this.needTextFence4SQL()) {
            String quoteStr = SQLTextUtils.addSQLTextFenceByDbType(field, this.dbType, true);
            quoteStr = SQLTextUtils.removeJavaTextFence(quoteStr);
            return quoteStr;
        }
        return field;
    }

    private String addTextFenceForSQLIfNecessary(String field) {
        return this.addTextFenceForSQLIfNecessary(field, true);
    }

    private String processResultSQL(String sql) {
        String suffix;
        if (sql != null && sql.endsWith(suffix = SQLTextUtils.getStringConnect() + "\"" + "\"")) {
            sql = sql.substring(0, sql.length() - suffix.length());
        }
        return sql;
    }

    private String generateColumnFields(String tableNameWithDBAndSchema) {
        StringBuffer fieldsSQL = new StringBuffer(100);
        Schema schema = this.setting.getSchema();
        List fields = schema.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            fieldsSQL.append("\n");
            fieldsSQL.append(" ");
            fieldsSQL.append(" ");
            fieldsSQL.append(tableNameWithDBAndSchema);
            fieldsSQL.append(this.getSQLFieldConnector());
            fieldsSQL.append(this.addTextFenceForSQLIfNecessary(field.getProp("talend.field.dbColumnName")));
            if (i >= fields.size() - 1) continue;
            fieldsSQL.append(",");
            fieldsSQL.append(" ");
        }
        return fieldsSQL.toString();
    }

    @Override
    public String generateQuery() {
        Schema schema = this.setting.getSchema();
        List fields = schema.getFields();
        if (fields != null && !fields.isEmpty()) {
            String tableNameWithDBAndSchema = this.getTableNameWithDBAndSchema(this.getDBName(), this.getDBSchemaName(), this.getDBTableName());
            String columnField = null;
            columnField = this.needFullName4Column() ? this.generateColumnFields(tableNameWithDBAndSchema) : this.generateColumnFields(this.getDBTableName());
            StringBuffer sql = new StringBuffer(100);
            sql.append("\"");
            sql.append("SELECT");
            sql.append(" ");
            sql.append(columnField);
            sql.append("\n");
            sql.append("FROM");
            sql.append(" ");
            sql.append(tableNameWithDBAndSchema);
            sql.append("\"");
            return this.processResultSQL(sql.toString());
        }
        return "";
    }

    protected boolean needFullName4Column() {
        return true;
    }

    protected boolean needTextFence4SQL() {
        return true;
    }
}

