/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.talend.components.jdbc.query.EDatabaseTypeName;

public class SQLTextUtils {
    private static final String JAVA_NEW_CONTEXT_PREFIX = "context.";
    private static final String QUOTE_PATTERN = "((?<!\\\\)\".*?(?<!\\\\)\")";
    private static Pattern javaLiteralPatternRegex = Pattern.compile("((?<!\\\\)\".*?(?<!\\\\)\")", 136);
    private static final String CONTEXT_AND_VARIABLE_PATTERN = "^[a-zA-Z\\_]+[a-zA-Z0-9\\_]*$";
    private static final String SINGLE_QUOTE = "'";
    private static final String ANTI_QUOTE = "`";
    private static final String QUOTATION_MARK = "\"";
    private static final String QUOTATION_ESC_MARK = "\"";
    private static final String LBRACKET = "[";
    private static final String RBRACKET = "]";
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public static String getStringDeclare() {
        return "\"";
    }

    public static String getStringConnect() {
        return "+";
    }

    public static boolean containContextVariables(String str) {
        if (str == null) {
            return false;
        }
        String nonQuoteStr = SQLTextUtils.filterQuote(str = str.trim());
        return SQLTextUtils.getVariableFromCode(nonQuoteStr) != null;
    }

    public static String removeJavaTextFence(String text) {
        if (text == null) {
            return null;
        }
        return SQLTextUtils.removeQuotes(text, "\"");
    }

    public static String addSQLTextFenceByDbType(String objectName, EDatabaseTypeName dbType, boolean simple) {
        String sqlTextFence = SQLTextUtils.getDatabaseObjectTextFenceByDBType(dbType, true);
        return SQLTextUtils.addSQLTextFence(objectName, sqlTextFence, simple);
    }

    private static String addSQLTextFence(String text, String sqlTextFence, boolean simple) {
        String con = SQLTextUtils.getStringConnect();
        if (simple) {
            text = SQLTextUtils.removeQuotes(text, SQLTextUtils.getStringDeclare());
        }
        String newString = sqlTextFence.equals(SINGLE_QUOTE) ? (simple ? SQLTextUtils.declareString(SINGLE_QUOTE + text + SINGLE_QUOTE) : SQLTextUtils.declareString(SINGLE_QUOTE) + con + text + con + SQLTextUtils.declareString(SINGLE_QUOTE)) : (sqlTextFence.equals(ANTI_QUOTE) ? (simple ? SQLTextUtils.declareString(ANTI_QUOTE + text + ANTI_QUOTE) : SQLTextUtils.declareString(ANTI_QUOTE) + con + text + con + SQLTextUtils.declareString(ANTI_QUOTE)) : (sqlTextFence.equals(LBRACKET) || sqlTextFence.equals(RBRACKET) ? (simple ? SQLTextUtils.declareString(LBRACKET + text + RBRACKET) : SQLTextUtils.declareString(LBRACKET) + con + text + con + SQLTextUtils.declareString(RBRACKET)) : (simple ? SQLTextUtils.declareString("\\\"" + text + "\\" + "\"") : SQLTextUtils.declareString("\\\"") + con + text + con + SQLTextUtils.declareString("\\\""))));
        return newString;
    }

    public static String declareString(String input) {
        if (input == null) {
            return null;
        }
        return SQLTextUtils.getStringDeclare() + input + SQLTextUtils.getStringDeclare();
    }

    public static String getDatabaseObjectTextFenceByDBType(EDatabaseTypeName name, boolean left) {
        switch (name) {
            case GODBC: {
                return "\"";
            }
            case IBMDB2: {
                return "\"";
            }
            case INGRES: {
                return "\"";
            }
            case MSODBC: {
                return "\"";
            }
            case MYSQL: 
            case AMAZON_AURORA: {
                return ANTI_QUOTE;
            }
            case ORACLEFORSID: {
                return "\"";
            }
            case ORACLESN: {
                return "\"";
            }
            case PSQL: 
            case GREENPLUM: 
            case PARACCEL: 
            case PLUSPSQL: {
                return "\"";
            }
            case SYBASEASE: {
                return "\"";
            }
            case SYBASEIQ: {
                return "\"";
            }
            case INTERBASE: {
                return "\"";
            }
            case SQLITE: {
                return "\"";
            }
            case FIREBIRD: {
                return "\"";
            }
            case INFORMIX: {
                return "\"";
            }
            case MSSQL: 
            case ACCESS: {
                return SQLTextUtils.getBracket(left);
            }
            case TERADATA: {
                return "\"";
            }
            case H2: {
                return "\"";
            }
        }
        return "\"";
    }

    private static String getBracket(boolean left) {
        if (left) {
            return LBRACKET;
        }
        return RBRACKET;
    }

    private static String removeQuotes(String text, String quotation) {
        if (text == null) {
            return null;
        }
        if (text.length() > 1) {
            String substring = text.substring(0, 1);
            if (quotation.equals(substring)) {
                text = text.substring(1, text.length());
            }
            if (quotation.equals(substring = text.substring(text.length() - 1, text.length()))) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private static String filterQuote(String str) {
        String newStr = SQLTextUtils.replaceNewLine(str);
        Matcher regexMatcher = javaLiteralPatternRegex.matcher(newStr);
        String nonQuoteStr = newStr;
        if (regexMatcher.find()) {
            String quoteStr = regexMatcher.group(1);
            int index = newStr.indexOf(quoteStr);
            nonQuoteStr = newStr.substring(0, index);
            nonQuoteStr = nonQuoteStr + newStr.substring(index + quoteStr.length());
            return SQLTextUtils.filterQuote(nonQuoteStr);
        }
        return nonQuoteStr;
    }

    private static String getVariableFromCode(String code) {
        return SQLTextUtils.getVariableFromCode(code, JAVA_NEW_CONTEXT_PREFIX);
    }

    private static String getVariableFromCode(String code, String prefix) {
        Pattern regex;
        Matcher regexMatcher;
        if (code == null) {
            return null;
        }
        String pattern = null;
        String varPattern = "(.+?)";
        String wordPattern = "\\b";
        pattern = wordPattern + SQLTextUtils.replaceCharForRegex(prefix) + varPattern + wordPattern;
        if (pattern != null && (regexMatcher = (regex = Pattern.compile(pattern, 128)).matcher(code)).find()) {
            try {
                String var = regexMatcher.group(1);
                if (var != null && SQLTextUtils.isValidParameterName(var)) {
                    return var;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isValidParameterName(String name) {
        if (name != null) {
            if (SQLTextUtils.isJavaKeyWords(name)) {
                return false;
            }
            return Pattern.matches(CONTEXT_AND_VARIABLE_PATTERN, name);
        }
        return false;
    }

    private static boolean isJavaKeyWords(String name) {
        return name == null ? false : JAVA_KEYWORDS.contains(name.toLowerCase());
    }

    private static String replaceCharForRegex(String pattern) {
        if (pattern == null) {
            return null;
        }
        pattern = pattern.replaceAll("\\(", "\\\\(");
        pattern = pattern.replaceAll("\\)", "\\\\)");
        int index = (pattern = pattern.replaceAll("\\.", "\\\\.")).indexOf("$");
        if (index > -1) {
            String str1 = pattern.substring(0, index);
            String str2 = pattern.substring(index + 1);
            pattern = str1 + "\\$" + str2;
        }
        return pattern;
    }

    private static String replaceNewLine(String str) {
        if (str == null) {
            return "";
        }
        String newStr = str;
        newStr = newStr.replace("\r", " ");
        newStr = newStr.replace("\n", " ");
        newStr = newStr.trim();
        return newStr;
    }
}

