/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.query;

import org.talend.components.jdbc.query.EDatabaseTypeName;
import org.talend.components.jdbc.query.IQueryGenerator;
import org.talend.components.jdbc.query.generator.AS400QueryGenerator;
import org.talend.components.jdbc.query.generator.DefaultQueryGenerator;
import org.talend.components.jdbc.query.generator.HiveQueryGenerator;
import org.talend.components.jdbc.query.generator.NetezzaQueryGenerator;

public final class GenerateQueryFactory {
    private GenerateQueryFactory() {
    }

    public static IQueryGenerator getGenerator(String dbType) {
        return GenerateQueryFactory.getGenerator(EDatabaseTypeName.getTypeFromDbType(dbType));
    }

    public static IQueryGenerator getGenerator(EDatabaseTypeName dbType) {
        if (dbType == null) {
            return null;
        }
        switch (dbType) {
            case HIVE: {
                return new HiveQueryGenerator(dbType);
            }
            case NETEZZA: {
                return new NetezzaQueryGenerator();
            }
            case AS400: {
                return new AS400QueryGenerator();
            }
        }
        return new DefaultQueryGenerator(dbType);
    }
}

