/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.query;

import org.talend.components.jdbc.query.EDatabaseSchemaOrCatalogMapping;

public enum EDatabaseTypeName {
    MYSQL("MySQL", "MySQL", Boolean.FALSE, "MYSQL", "MYSQL", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    AMAZON_AURORA("Amazon Aurora", "Amazon Aurora", Boolean.FALSE, "AMAZON_AURORA", "AMAZON_AURORA", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    PSQL("PostgreSQL", "PostgreSQL", Boolean.TRUE, "POSTGRESQL", "POSTGRE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    PLUSPSQL("PostgresPlus", "PostgresPlus", Boolean.TRUE, "POSTGRESPLUS", "POSTGREPLUS", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    ORACLEFORSID("ORACLE_SID", "Oracle with SID", Boolean.TRUE, "ORACLE", "DBORACLE", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    ORACLESN("ORACLE_SERVICE_NAME", "Oracle with service name", Boolean.TRUE, "ORACLE", "DBORACLE", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    ORACLE_OCI("ORACLE_OCI", "Oracle OCI", Boolean.TRUE, "ORACLE", "DBORACLE", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    ORACLE_CUSTOM("ORACLE_CUSTOM", "Oracle Custom", Boolean.TRUE, "ORACLE", "DBORACLE", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    GODBC("Generic ODBC", "Generic ODBC (Unsupported)", Boolean.FALSE, "ODBC", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    MSODBC("Microsoft SQL (Odbc driver)", "Microsoft SQL Server (Odbc driver, Unsupported)", Boolean.FALSE, "ODBC", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    IBMDB2("IBM DB2", "IBM DB2", Boolean.TRUE, "IBM_DB2", "DB2", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    IBMDB2ZOS("IBM DB2 ZOS", "IBM DB2 ZOS", Boolean.TRUE, "IBM_DB2", "DB2", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    SYBASEASE("SybaseASE", "Sybase (ASE and IQ)", Boolean.TRUE, "SYBASE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    SYBASEIQ("Sybase IQ", "Sybase IQ", Boolean.TRUE, "SYBASE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    MSSQL("MSSQL", "Microsoft SQL Server", Boolean.TRUE, "SQL_SERVER", "MSSQL", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    MSSQL05_08("MSSQL", "Microsoft SQL Server 2005/2008", Boolean.TRUE, "SQL_SERVER", "MSSQL", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    HSQLDB("HSQLDB", "HSQLDB", Boolean.FALSE, "HSQLDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    HSQLDB_SERVER("HSQLDB Server", "HSQLDB Server", Boolean.FALSE, "HSQLDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    HSQLDB_WEBSERVER("HSQLDB WebServer", "HSQLDB WebServer", Boolean.FALSE, "HSQLDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    HSQLDB_IN_PROGRESS("HSQLDB In-Process", "HSQLDB In-Process", Boolean.FALSE, "HSQLDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    JAVADB("JavaDB", "JavaDB", Boolean.FALSE, "JAVADB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    INGRES("Ingres", "Ingres", Boolean.FALSE, "INGRES", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    INTERBASE("Interbase", "Interbase", Boolean.FALSE, "INTERBASE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    SQLITE("SQLite", "SQLite", Boolean.FALSE, "SQLITE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    FIREBIRD("FireBird", "FireBird", Boolean.FALSE, "FIREBIRD", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    INFORMIX("Informix", "Informix", Boolean.TRUE, "INFORMIX", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    VECTORWISE("VectorWise", "VectorWise", Boolean.FALSE, "VECTORWISE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    ACCESS("Access", "Access", Boolean.FALSE, "ACCESS", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Default_Name),
    TERADATA("Teradata", "Teradata", Boolean.TRUE, "TERADATA", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    AS400("AS400", "AS400", Boolean.FALSE, "AS400", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Login),
    JAVADB_EMBEDED("JavaDB Embeded", "JavaDB Embeded", Boolean.FALSE, "JAVADB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    JAVADB_JCCJDBC("JavaDB JCCJDBC", "JavaDB JCCJDBC", Boolean.FALSE, "JAVADB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    JAVADB_DERBYCLIENT("JavaDB DerbyClient", "JavaDB DerbyClient", Boolean.FALSE, "JAVADB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    VERTICA("Vertica", "Vertica", Boolean.TRUE, "VERTICA", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    MAXDB("MAXDB", "MaxDB", Boolean.FALSE, "MAXDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    GREENPLUM("Greenplum", "Greenplum", Boolean.TRUE, "GREENPLUM", "GREENPLUM", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    PARACCEL("ParAccel", "ParAccel", Boolean.TRUE, "PARACCEL", "PARACCEL", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    NETEZZA("Netezza", "Netezza", Boolean.FALSE, "NETEZZA", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    SAS("SAS", "SAS", Boolean.TRUE, "SAS", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    GENERAL_JDBC("General JDBC", "General JDBC", Boolean.FALSE, "JDBC", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    EXASOL("Exasol", "Exasol", Boolean.TRUE, "Exasol", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    HIVE("Hive", "Hive", Boolean.FALSE, "HIVE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    SAPHana("SAPHana", "SAPHana", Boolean.TRUE, "SAPHANA", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    H2("H2", "H2", Boolean.FALSE, "H2", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.None),
    REDSHIFT("Redshift", "Redshift", Boolean.TRUE, "REDSHIFT", "REDSHIFT", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Schema),
    IMPALA("IMPALA", "Impala", Boolean.TRUE, "IMPALA", EDatabaseSchemaOrCatalogMapping.None, EDatabaseSchemaOrCatalogMapping.Schema),
    HBASE("HBase", "HBase", Boolean.FALSE, "HBASE", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Column_Family, true),
    MAPRDB("MapRDB", "MapRDB", Boolean.FALSE, "MAPRDB", EDatabaseSchemaOrCatalogMapping.Sid, EDatabaseSchemaOrCatalogMapping.Column_Family, true);

    private String displayName;
    private Boolean isNeedSchema;
    private String dbType;
    private String product;
    private String xmlType;
    private boolean useProvider = false;
    private EDatabaseSchemaOrCatalogMapping catalogMappingField;
    private EDatabaseSchemaOrCatalogMapping schemaMappingField;

    public EDatabaseSchemaOrCatalogMapping getCatalogMappingField() {
        return this.catalogMappingField;
    }

    public EDatabaseSchemaOrCatalogMapping getSchemaMappingField() {
        return this.schemaMappingField;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean isNeedSchema() {
        return this.isNeedSchema;
    }

    public String getXmlName() {
        return this.dbType;
    }

    public String getProduct() {
        return this.product;
    }

    public String getXMLType() {
        return this.xmlType;
    }

    private EDatabaseTypeName(String dbType, String displayName, Boolean isNeedSchema, String product, EDatabaseSchemaOrCatalogMapping catalogMappingField, EDatabaseSchemaOrCatalogMapping schemaMappingField) {
        this.displayName = displayName;
        this.isNeedSchema = isNeedSchema;
        this.dbType = dbType;
        this.product = product;
        this.xmlType = product;
        this.catalogMappingField = catalogMappingField;
        this.schemaMappingField = schemaMappingField;
    }

    private EDatabaseTypeName(String dbType, String displayName, Boolean isNeedSchema, String product, EDatabaseSchemaOrCatalogMapping catalogMappingField, EDatabaseSchemaOrCatalogMapping schemaMappingField, boolean useProvider) {
        this(dbType, displayName, isNeedSchema, product, catalogMappingField, schemaMappingField);
        this.useProvider = useProvider;
    }

    private EDatabaseTypeName(String dbType, String displayName, Boolean isNeedSchema, String product, String xmlType, EDatabaseSchemaOrCatalogMapping catalogMappingField, EDatabaseSchemaOrCatalogMapping schemaMappingField) {
        this.displayName = displayName;
        this.isNeedSchema = isNeedSchema;
        this.dbType = dbType;
        this.product = product;
        this.xmlType = xmlType;
        this.catalogMappingField = catalogMappingField;
        this.schemaMappingField = schemaMappingField;
    }

    public static EDatabaseTypeName getTypeFromDbType(String dbType) {
        if (dbType == null) {
            return EDatabaseTypeName.getTypeFromDispalyNameOriginal(dbType);
        }
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (typename.getXmlName().toUpperCase().equals(dbType.toUpperCase())) {
                return typename;
            }
            if (!typename.getProduct().toUpperCase().equals(dbType.toUpperCase())) continue;
            return typename;
        }
        return EDatabaseTypeName.getTypeFromDispalyNameOriginal(dbType);
    }

    public static EDatabaseTypeName getTypeFromDbType(String dbType, boolean isDefault) {
        if (dbType == null) {
            return EDatabaseTypeName.getTypeFromDisplayNameOriginal(dbType, isDefault);
        }
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (typename.getXmlName().toUpperCase().equals(dbType.toUpperCase())) {
                return typename;
            }
            if (!typename.getProduct().toUpperCase().equals(dbType.toUpperCase())) continue;
            return typename;
        }
        return EDatabaseTypeName.getTypeFromDisplayNameOriginal(dbType, isDefault);
    }

    public static EDatabaseTypeName getTypeFromDisplayName(String displayName) {
        return EDatabaseTypeName.getTypeFromDbType(displayName);
    }

    private static EDatabaseTypeName getTypeFromDispalyNameOriginal(String displayName) {
        if (displayName == null) {
            return MYSQL;
        }
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (!typename.getDisplayName().toLowerCase().equals(displayName.toLowerCase())) continue;
            return typename;
        }
        return MYSQL;
    }

    public static EDatabaseTypeName getTypeFromDisplayName(String displayName, boolean isDefault) {
        return EDatabaseTypeName.getTypeFromDisplayNameOriginal(displayName, isDefault);
    }

    private static EDatabaseTypeName getTypeFromDisplayNameOriginal(String displayName, boolean isDefault) {
        if (displayName == null && isDefault) {
            return MYSQL;
        }
        if (displayName == null) {
            return null;
        }
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (!typename.getDisplayName().toLowerCase().equals(displayName.toLowerCase())) continue;
            return typename;
        }
        return isDefault ? MYSQL : null;
    }

    public static EDatabaseTypeName getTypeFromProductName(String productName) {
        if (productName == null) {
            return MYSQL;
        }
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (!typename.getProduct().equals(productName)) continue;
            return typename;
        }
        return MYSQL;
    }

    public static boolean supportDbType(String dbType) {
        for (EDatabaseTypeName typename : EDatabaseTypeName.values()) {
            if (!typename.getXmlName().equals(dbType)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseProvider() {
        return this.useProvider;
    }
}

