/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.query;

import java.util.ArrayList;
import java.util.List;
import org.talend.components.jdbc.query.EDatabaseTypeName;

public enum EDatabase4DriverClassName {
    ACCESS(EDatabaseTypeName.ACCESS, "net.ucanaccess.jdbc.UcanaccessDriver"),
    AS400(EDatabaseTypeName.AS400, "com.ibm.as400.access.AS400JDBCDriver"),
    FIREBIRD(EDatabaseTypeName.FIREBIRD, "org.firebirdsql.jdbc.FBDriver"),
    GODBC(EDatabaseTypeName.GODBC, "sun.jdbc.odbc.JdbcOdbcDriver"),
    HSQLDB(EDatabaseTypeName.HSQLDB, "org.hsqldb.jdbcDriver"),
    HSQLDB_IN_PROGRESS(EDatabaseTypeName.HSQLDB_IN_PROGRESS, "org.hsqldb.jdbcDriver"),
    HSQLDB_SERVER(EDatabaseTypeName.HSQLDB_SERVER, "org.hsqldb.jdbcDriver"),
    HSQLDB_WEBSERVER(EDatabaseTypeName.HSQLDB_WEBSERVER, "org.hsqldb.jdbcDriver"),
    IBMDB2(EDatabaseTypeName.IBMDB2, "com.ibm.db2.jcc.DB2Driver"),
    IBMDB2ZOS(EDatabaseTypeName.IBMDB2ZOS, "COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver"),
    INFORMIX(EDatabaseTypeName.INFORMIX, "com.informix.jdbc.IfxDriver"),
    INGRES(EDatabaseTypeName.INGRES, "com.ingres.jdbc.IngresDriver"),
    INTERBASE(EDatabaseTypeName.INTERBASE, "interbase.interclient.Driver"),
    VECTORWISE(EDatabaseTypeName.VECTORWISE, "com.ingres.jdbc.IngresDriver"),
    JAVADB_DERBYCLIENT(EDatabaseTypeName.JAVADB_DERBYCLIENT, "org.apache.derby.jdbc.ClientDriver"),
    JAVADB_EMBEDED(EDatabaseTypeName.JAVADB_EMBEDED, "org.apache.derby.jdbc.EmbeddedDriver"),
    JAVADB_JCCJDBC(EDatabaseTypeName.JAVADB_JCCJDBC, "com.ibm.db2.jcc.DB2Driver"),
    MAXDB(EDatabaseTypeName.MAXDB, "com.sap.dbtech.jdbc.DriverSapDB"),
    MSODBC(EDatabaseTypeName.MSODBC, "sun.jdbc.odbc.JdbcOdbcDriver"),
    MSSQL(EDatabaseTypeName.MSSQL, "net.sourceforge.jtds.jdbc.Driver"),
    MSSQL2(EDatabaseTypeName.MSSQL05_08, "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
    MYSQL(EDatabaseTypeName.MYSQL, "org.gjt.mm.mysql.Driver"),
    MYSQL2(EDatabaseTypeName.MYSQL, "com.mysql.jdbc.Driver"),
    MARIADB(EDatabaseTypeName.MYSQL, "org.mariadb.jdbc.Driver"),
    AMAZON_AURORA(EDatabaseTypeName.AMAZON_AURORA, "org.gjt.mm.mysql.Driver"),
    NETEZZA(EDatabaseTypeName.NETEZZA, "org.netezza.Driver"),
    ORACLEFORSID(EDatabaseTypeName.ORACLEFORSID, "oracle.jdbc.OracleDriver", "oracle.jdbc.driver.OracleDriver"),
    ORACLESN(EDatabaseTypeName.ORACLESN, "oracle.jdbc.OracleDriver", "oracle.jdbc.driver.OracleDriver"),
    ORACLE_OCI(EDatabaseTypeName.ORACLE_OCI, "oracle.jdbc.OracleDriver", "oracle.jdbc.driver.OracleDriver"),
    ORACLE_CUSTOM(EDatabaseTypeName.ORACLE_CUSTOM, "oracle.jdbc.OracleDriver", "oracle.jdbc.driver.OracleDriver"),
    PARACCEL(EDatabaseTypeName.PARACCEL, "com.paraccel.Driver"),
    REDSHIFT(EDatabaseTypeName.REDSHIFT, "com.amazon.redshift.jdbc41.Driver"),
    PSQL(EDatabaseTypeName.PSQL, "org.postgresql.Driver"),
    PLUSPSQL(EDatabaseTypeName.PLUSPSQL, "org.postgresql.Driver"),
    GREENPLUM(EDatabaseTypeName.GREENPLUM, "org.postgresql.Driver"),
    SAS(EDatabaseTypeName.SAS, "com.sas.rio.MVADriver"),
    SAPHana(EDatabaseTypeName.SAPHana, "com.sap.db.jdbc.Driver"),
    SQLITE(EDatabaseTypeName.SQLITE, "org.sqlite.JDBC"),
    SYBASEASE(EDatabaseTypeName.SYBASEASE, new String[]{"com.sybase.jdbc3.jdbc.SybDriver", "com.sybase.jdbc3.jdbc.SybDataSource"}, new String[0]),
    SYBASEIQ(EDatabaseTypeName.SYBASEIQ, new String[]{"com.sybase.jdbc3.jdbc.SybDriver", "com.sybase.jdbc3.jdbc.SybDataSource"}, new String[0]),
    SYBASEIQ_16(EDatabaseTypeName.SYBASEASE, new String[]{"com.sybase.jdbc4.jdbc.SybDriver", "com.sybase.jdbc4.jdbc.SybDataSource"}, new String[0]),
    EXASOLUTION(EDatabaseTypeName.EXASOL, "com.exasol.jdbc.EXADriver"),
    TERADATA(EDatabaseTypeName.TERADATA, "com.teradata.jdbc.TeraDriver"),
    VERTICA(EDatabaseTypeName.VERTICA, "com.vertica.Driver"),
    VERTICA2(EDatabaseTypeName.VERTICA, "com.vertica.jdbc.Driver"),
    HIVE(EDatabaseTypeName.HIVE, "org.apache.hadoop.hive.jdbc.HiveDriver"),
    HIVE2(EDatabaseTypeName.HIVE, "org.apache.hive.jdbc.HiveDriver"),
    IMPALA(EDatabaseTypeName.IMPALA, "org.apache.hive.jdbc.HiveDriver"),
    H2(EDatabaseTypeName.H2, "org.h2.Driver");

    private EDatabaseTypeName dbType;
    private String[] usingDriverClasses;
    private String[] deprecatedDriverClasses;

    private EDatabase4DriverClassName(EDatabaseTypeName dbType, String[] usingDriverClasses, String[] deprecatedDriverClasses) {
        this.dbType = dbType;
        this.usingDriverClasses = usingDriverClasses;
        this.deprecatedDriverClasses = deprecatedDriverClasses;
    }

    private EDatabase4DriverClassName(EDatabaseTypeName dbType, String driverClass, String deprecatedDriverClass) {
        this(dbType, new String[]{driverClass}, new String[]{deprecatedDriverClass});
    }

    private EDatabase4DriverClassName(EDatabaseTypeName dbType, String driverClass) {
        this(dbType, new String[]{driverClass}, new String[0]);
    }

    public EDatabaseTypeName getDbType() {
        return this.dbType;
    }

    public String getDbTypeName() {
        return this.dbType.getXmlName();
    }

    public String getDriverClass() {
        if (this.usingDriverClasses != null && this.usingDriverClasses.length > 0) {
            return this.usingDriverClasses[0];
        }
        return null;
    }

    public String[] getDriverClasses() {
        return this.usingDriverClasses;
    }

    public String[] getDeprecatedDriverClasses() {
        return this.deprecatedDriverClasses;
    }

    public static EDatabase4DriverClassName indexOfByDbType(String dbType) {
        EDatabaseTypeName db;
        if (dbType != null && (db = EDatabaseTypeName.getTypeFromDbType(dbType)) != null) {
            for (EDatabase4DriverClassName t4d : EDatabase4DriverClassName.values()) {
                if (t4d.getDbType() != db) continue;
                return t4d;
            }
        }
        return null;
    }

    public static List<EDatabase4DriverClassName> indexOfByDriverClass(String driverClass) {
        ArrayList<EDatabase4DriverClassName> dbType4Drivers = new ArrayList<EDatabase4DriverClassName>();
        block0: for (EDatabase4DriverClassName t4d : EDatabase4DriverClassName.values()) {
            String[] drivers = t4d.getDriverClasses();
            if (drivers != null) {
                for (String driver : drivers) {
                    if (!driver.equals(driverClass)) continue;
                    dbType4Drivers.add(t4d);
                    break;
                }
            }
            if ((drivers = t4d.getDeprecatedDriverClasses()) == null || dbType4Drivers.contains((Object)t4d)) continue;
            for (String driver : drivers) {
                if (!driver.equals(driverClass)) continue;
                dbType4Drivers.add(t4d);
                continue block0;
            }
        }
        return dbType4Drivers;
    }

    public static String getDriverClassByDbType(String dbType) {
        EDatabase4DriverClassName t4d = EDatabase4DriverClassName.indexOfByDbType(dbType);
        if (t4d != null) {
            return t4d.getDriverClass();
        }
        return null;
    }
}

