/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.module;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.talend.components.api.properties.ComponentPropertiesImpl;
import org.talend.components.common.UserPasswordProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.module.DriverTable;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class JDBCConnectionModule
extends ComponentPropertiesImpl {
    public Property<String> jdbcUrl = PropertyFactory.newProperty((String)"jdbcUrl").setRequired();
    public DriverTable driverTable = new DriverTable("driverTable");
    public Property<String> driverClass = PropertyFactory.newProperty((String)"driverClass").setRequired();
    public transient PresentationItem selectClass = new PresentationItem("selectClass");
    public UserPasswordProperties userPassword = new UserPasswordProperties("userPassword");
    private boolean useInWizard = false;

    public JDBCConnectionModule(String name) {
        super(name);
    }

    public void setupProperties() {
        super.setupProperties();
        this.jdbcUrl.setValue((Object)"jdbc:");
    }

    public void setupLayout() {
        super.setupLayout();
        Form form = CommonUtils.addForm((Properties)this, "Main");
        form.addRow(this.jdbcUrl);
        form.addRow(Widget.widget((NamedThing)this.driverTable).setWidgetType("widget.type.table"));
        if (this.useInWizard) {
            form.addRow(Widget.widget(this.driverClass).setWidgetType("widget.type.enumeration"));
            form.addColumn(Widget.widget((NamedThing)this.selectClass).setWidgetType("widget.type.button"));
        } else {
            form.addRow(this.driverClass);
        }
        form.addRow((NamedThing)this.userPassword.getForm("Main"));
    }

    public ValidationResult afterSelectClass() {
        ArrayList<String> driverClasses = new ArrayList<String>();
        AllSetting setting = new AllSetting();
        setting.setDriverPaths(this.driverTable.drivers.getValue());
        List<String> jar_maven_paths = setting.getDriverPaths();
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String maven_path : jar_maven_paths) {
                URL url = new URL(this.removeQuote(maven_path));
                urls.add(url);
            }
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            for (URL jarUrl : urls) {
                JarInputStream jarInputStream = new JarInputStream(jarUrl.openStream());
                Throwable throwable = null;
                try {
                    JarEntry nextJarEntry = jarInputStream.getNextJarEntry();
                    while (nextJarEntry != null) {
                        String name;
                        boolean isFile;
                        boolean bl = isFile = !nextJarEntry.isDirectory();
                        if (isFile && (name = nextJarEntry.getName()) != null && name.toLowerCase().endsWith(".class")) {
                            String className = this.changeFileNameToClassName(name);
                            try {
                                Class<?> clazz = classLoader.loadClass(className);
                                if (Driver.class.isAssignableFrom(clazz)) {
                                    driverClasses.add(clazz.getName());
                                }
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                        nextJarEntry = jarInputStream.getNextJarEntry();
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (jarInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            jarInputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    jarInputStream.close();
                }
            }
        }
        catch (Exception ex) {
            return new ValidationResult(ValidationResult.Result.ERROR, ex.getMessage());
        }
        if (driverClasses.isEmpty()) {
            return new ValidationResult(ValidationResult.Result.ERROR, "not found any Driver class, please make sure the jar is right");
        }
        this.driverClass.setPossibleValues(driverClasses);
        this.driverClass.setValue(driverClasses.get(0));
        return ValidationResult.OK;
    }

    private String changeFileNameToClassName(String name) {
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        name = name.substring(0, name.length() - 6);
        return name;
    }

    private String removeQuote(String content) {
        if (content.startsWith("\"") && content.endsWith("\"")) {
            return content.substring(1, content.length() - 1);
        }
        return content;
    }

    public void setNotRequired() {
        this.jdbcUrl.setRequired(false);
        this.driverClass.setRequired(false);
        this.userPassword.userId.setRequired(false);
        this.userPassword.password.setRequired(false);
    }

    public JDBCConnectionModule useInWizard() {
        this.useInWizard = true;
        return this;
    }
}

