/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.datastore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.api.properties.ComponentBasePropertiesImpl;
import org.talend.components.common.datastore.DatastoreProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.dataprep.DBType;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class JDBCDatastoreProperties
extends ComponentBasePropertiesImpl
implements DatastoreProperties,
RuntimeSettingProvider {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCDatastoreProperties.class);
    private transient Map<String, DBType> dyTypesInfo = new LinkedHashMap<String, DBType>();
    private static final String CONFIG_FILE_lOCATION_KEY = "org.talend.component.jdbc.config.file";
    public Property<String> dbTypes = PropertyFactory.newString((String)"dbTypes").setRequired();
    public Property<String> jdbcUrl = PropertyFactory.newProperty((String)"jdbcUrl").setRequired();
    public Property<String> userId = PropertyFactory.newProperty((String)"userId").setRequired();
    public Property<String> password = PropertyFactory.newProperty((String)"password").setRequired().setFlags(EnumSet.of(Property.Flags.ENCRYPT, Property.Flags.SUPPRESS_LOGGING));

    public JDBCDatastoreProperties(String name) {
        super(name);
        InputStream is;
        String config_file = System.getProperty(CONFIG_FILE_lOCATION_KEY);
        if (config_file != null) {
            try {
                is = new FileInputStream(config_file);
            }
            catch (FileNotFoundException e) {
                throw new ComponentException((ErrorCode)CommonErrorCodes.UNABLE_TO_READ_CONTENT, (Throwable)e);
            }
        } else {
            is = this.getClass().getClassLoader().getResourceAsStream("jdbc_config.json");
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream("db_type_config.json");
            }
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = null;
            jsonNode = objectMapper.readTree((Reader)new InputStreamReader(is));
            for (JsonNode jo : jsonNode) {
                DBType type = new DBType();
                type.id = jo.get("id").asText();
                type.clazz = jo.get("class").asText();
                type.url = jo.get("url").asText();
                JsonNode paths = jo.get("paths");
                Iterator iterator = paths.iterator();
                while (iterator.hasNext()) {
                    JsonNode path;
                    JsonNode jo_path = path = (JsonNode)iterator.next();
                    type.paths.add(jo_path.get("path").asText());
                }
                this.dyTypesInfo.put(type.id, type);
            }
        }
        catch (IOException e) {
            throw new ComponentException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error("failed to close JDBC config file", (Throwable)e);
                }
            }
        }
    }

    public void setupProperties() {
        super.setupProperties();
        ArrayList<String> dbTypesId = new ArrayList<String>();
        for (String id : this.dyTypesInfo.keySet()) {
            dbTypesId.add(id);
        }
        DBType defaultDBType = this.dyTypesInfo.get(dbTypesId.get(0));
        this.dbTypes.setPossibleValues(dbTypesId);
        this.dbTypes.setValue((Object)defaultDBType.id);
        this.jdbcUrl.setValue((Object)"");
    }

    public void setupLayout() {
        super.setupLayout();
        Form mainForm = CommonUtils.addForm((Properties)this, "Main");
        mainForm.addRow(Widget.widget(this.dbTypes).setWidgetType("widget.type.enumeration"));
        mainForm.addRow(Widget.widget(this.jdbcUrl).setWidgetType("widget.type.textArea").setConfigurationValue("widget.conf.placeholder", (Object)this.getCurrentDBType().url));
        mainForm.addRow(this.userId);
        mainForm.addRow(Widget.widget(this.password).setWidgetType("widget.type.hidden.text"));
    }

    public void afterDbTypes() {
        DBType currentDBType = this.getCurrentDBType();
        Widget jdbcUrlWIdget = this.getForm("Main").getWidget(this.jdbcUrl);
        jdbcUrlWIdget.setConfigurationValue("widget.conf.placeholder", (Object)currentDBType.url);
    }

    @Override
    public AllSetting getRuntimeSetting() {
        AllSetting setting = new AllSetting();
        setting.setDriverPaths(this.getCurrentDriverPaths());
        setting.setDriverClass(this.getCurrentDriverClass());
        setting.setJdbcUrl((String)this.jdbcUrl.getValue());
        setting.setUsername((String)this.userId.getValue());
        setting.setPassword((String)this.password.getValue());
        return setting;
    }

    private DBType getCurrentDBType() {
        return this.dyTypesInfo.get(this.dbTypes.getValue());
    }

    public List<String> getCurrentDriverPaths() {
        ArrayList<String> mavenPaths = new ArrayList<String>();
        DBType currentDBType = this.dyTypesInfo.get(this.dbTypes.getValue());
        if (currentDBType != null) {
            mavenPaths.addAll(currentDBType.paths);
        }
        return mavenPaths;
    }

    public String getCurrentDriverClass() {
        DBType currentDBType = this.dyTypesInfo.get(this.dbTypes.getValue());
        if (currentDBType == null) {
            return null;
        }
        return currentDBType.clazz;
    }
}

