/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.datastore;

import org.talend.components.common.dataset.DatasetProperties;
import org.talend.components.common.datastore.DatastoreDefinition;
import org.talend.components.jdbc.JdbcRuntimeInfo;
import org.talend.components.jdbc.dataprep.JDBCInputDefinition;
import org.talend.components.jdbc.dataset.JDBCDatasetProperties;
import org.talend.components.jdbc.datastore.JDBCDatastoreProperties;
import org.talend.daikon.definition.DefinitionImageType;
import org.talend.daikon.definition.I18nDefinition;
import org.talend.daikon.runtime.RuntimeInfo;

public class JDBCDatastoreDefinition
extends I18nDefinition
implements DatastoreDefinition<JDBCDatastoreProperties> {
    public static final String NAME = "JDBCDatastore";

    public JDBCDatastoreDefinition() {
        super(NAME);
    }

    public RuntimeInfo getRuntimeInfo(JDBCDatastoreProperties properties) {
        return new JdbcRuntimeInfo(properties, "org.talend.components.jdbc.runtime.dataprep.JDBCDatastoreRuntime");
    }

    public DatasetProperties createDatasetProperties(JDBCDatastoreProperties storeProp) {
        JDBCDatasetProperties datasetProperties = new JDBCDatasetProperties("dataset");
        datasetProperties.init();
        datasetProperties.setDatastoreProperties(storeProp);
        return datasetProperties;
    }

    public String getInputCompDefinitionName() {
        return JDBCInputDefinition.NAME;
    }

    public String getOutputCompDefinitionName() {
        return null;
    }

    @Deprecated
    public String getImagePath() {
        return "JDBCDatastore_icon32.png";
    }

    public String getImagePath(DefinitionImageType type) {
        switch (type) {
            case PALETTE_ICON_32X32: {
                return "JDBCDatastore_icon32.png";
            }
            case SVG_ICON: {
                return null;
            }
        }
        return null;
    }

    public String getIconKey() {
        return "db-input";
    }

    public Class<JDBCDatastoreProperties> getPropertiesClass() {
        return JDBCDatastoreProperties.class;
    }
}

